package com.biz.crm.achievement.controller;

import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementAccomplishRecordReqVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 完成指标，发送MQ写入记录表
 * @author yangshan
 * @date 2021/3/29 14:05
 */
@Slf4j
public class AchievementRecordsMQSend {

    private static RocketMQProducer rocketMQProducer = SpringApplicationContextUtil.getApplicationContext().getBean(RocketMQProducer.class);

    public static void saveAchievementRecordsMQ(SfaAchievementAccomplishRecordReqVo req){
        String createOrgCodeList = "";
        if (StringUtils.isNotEmpty(req.getCreateOrgCode())){
            List<MdmOrgRespVo> orgList = OrgUtil.getParentOrgListIncludeSelf(req.getCreateOrgCode());
            if (CollectionUtil.listNotEmpty(orgList)){
                createOrgCodeList = orgList.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.joining(","));
            }
        }
        //mq写入绩效表
        req.setCreateOrgCodeList(createOrgCodeList);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag(RocketMQConstant.CRM_MQ_TAG.INDEX_ACCOMPLISH_RECORDS_TAG);
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(req));
        rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }
}
