package com.biz.crm.achievement.controller;

import com.biz.crm.achievement.service.ISfaAchievementAccomplishRecordService;
import com.biz.crm.achievement.service.ISfaAchievementRuleService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementAccomplishRecordReqVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementRuleReqVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementRuleTableReqVo;
import com.biz.crm.nebular.sfa.achievement.resp.SfaAchievementRuleTableRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author yangshan
 * @date 2021-2-25 12:56:27
 */
@Slf4j
@RestController
@RequestMapping("/SfaAchievementRuleController")
@Api(tags = "绩效规则设置")
public class SfaAchievementRuleController {

    @Autowired
    private ISfaAchievementRuleService sfaAchievementRuleService;

    @Autowired
    private ISfaAchievementAccomplishRecordService sfaAchievementAccomplishRecordService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaAchievementRuleTableRespVo>> list(@RequestBody SfaAchievementRuleTableReqVo reqVo) {
        PageResult<SfaAchievementRuleTableRespVo> result = sfaAchievementRuleService.findList(reqVo);
        return Result.ok(result);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaAchievementRuleReqVo reqVo) {
        sfaAchievementRuleService.save(reqVo);
        return Result.ok();
    }


    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        sfaAchievementRuleService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 小程序列表（本月，上月）
     */
    @ApiOperation(value = "小程序列表",httpMethod = "GET")
    @GetMapping("/miniListThisMonth")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "timeType", value = "时间类型（by 本月 sy 上月）", required = false, dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "objectCode", value = "对象编码", required = false, dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "positionCode", value = "对象职位编码", required = false, dataType = "String", paramType = "query")
    })
    @CrmLog
    public Result<List<SfaAchievementRuleTableRespVo>> miniListThisMonth(@RequestParam(value = "timeType",required = false) String timeType,
                                                                         @RequestParam(value = "objectCode",required = false) String objectCode,
                                                                         @RequestParam(value = "positionCode",required = false) String objectPosCode) {
        Result<List<SfaAchievementRuleTableRespVo>> result = new Result<>();
        if(StringUtils.isEmpty(timeType)){
            result.error500("请传入时间类型");
            return result;
        }
        if(StringUtils.isEmpty(objectCode)
                && StringUtils.isEmpty(objectPosCode)){
            result.error500("请传入对象编码或对象职位编码");
            return result;
        }
        List<SfaAchievementRuleTableRespVo> resultList = sfaAchievementRuleService.miniListThisMonth(timeType, objectCode, objectPosCode);
        return Result.ok(resultList);
    }

    /**
     * 新增记录
     */
    @ApiOperation(value = "新增指标完成记录")
    @PostMapping("/saveAchievementAccomplishRecord")
    @CrmLog
    @Deprecated
    public Result saveAchievementAccomplishRecord(@RequestBody List<SfaAchievementAccomplishRecordReqVo> reqVo) {
        sfaAchievementAccomplishRecordService.save(reqVo);
        return Result.ok();
    }

    /**
     * 删除记录
     */
    @ApiOperation(value = "删除指标完成记录",httpMethod = "GET")
    @GetMapping("/deleteAchievementAccomplishRecord")
    @CrmLog
    public Result deleteAchievementAccomplishRecord(@RequestParam("relationId") String relationId) {
        sfaAchievementAccomplishRecordService.delete(relationId);
        return Result.ok();
    }

    /**
     * 删除记录
     */
    @ApiOperation(value = "逻辑删除指标完成记录",httpMethod = "GET")
    @GetMapping("/deleteByRelationId")
    @CrmLog
    public Result deleteByRelationId(@RequestParam("relationId") String relationId) {
        sfaAchievementAccomplishRecordService.deleteByRelationId(relationId);
        return Result.ok();
    }
    /**
     * 启用
     */
    @ApiOperation(value = "启用指标完成记录",httpMethod = "GET")
    @GetMapping("/reuseByRelationId")
    @CrmLog
    public Result reuseByRelationId(@RequestParam("relationId") String relationId) {
        sfaAchievementAccomplishRecordService.reuseByRelationId(relationId);
        return Result.ok();
    }

}
