package com.biz.crm.achievement.controller;

import com.biz.crm.achievement.service.ISfaIndexService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.achievement.req.SfaIndexReqVo;
import com.biz.crm.nebular.sfa.achievement.resp.SfaIndexRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author yangshan
 * @date 2021-2-23 19:45:01
 */
@Slf4j
@RestController
@RequestMapping("/SfaIndexController")
@Api(tags = "指标")
public class SfaIndexController {

    @Autowired
    private ISfaIndexService sfaIndexService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaIndexRespVo>> list(@RequestBody SfaIndexReqVo sfaIndexReqVo) {
        PageResult<SfaIndexRespVo> result=sfaIndexService.findList(sfaIndexReqVo);
        return Result.ok(result);
    }


    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaIndexReqVo sfaIndexReqVo) {
        sfaIndexService.save(sfaIndexReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaIndexReqVo sfaIndexReqVo) {
        sfaIndexService.update(sfaIndexReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        sfaIndexService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        sfaIndexService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        sfaIndexService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
