package com.biz.crm.achievement.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.achievement.model.SfaAchievementRuleEntity;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementRuleTableReqVo;
import com.biz.crm.nebular.sfa.achievement.resp.SfaAchievementRuleTableRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author yangshan
 * @date 2021-2-25 12:56:27
 */
public interface SfaAchievementRuleMapper extends BaseMapper<SfaAchievementRuleEntity> {
    /**
     * 列表
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "n.VISIT_POS_CODE", orgCode = "n.CREATE_ORG_CODE")
    List<SfaAchievementRuleTableRespVo> findList(Page<SfaAchievementRuleTableRespVo> page, @Param("vo") SfaAchievementRuleTableReqVo reqVo);

    /**
     * 小程序列表（查询本月或上月）
     * @param reqVo
     * @return
     */
    List<SfaAchievementRuleTableRespVo> miniList(@Param("vo") SfaAchievementRuleTableReqVo reqVo);
}
