package com.biz.crm.achievement.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.achievement.mapper.SfaIndexMapper;
import com.biz.crm.achievement.model.SfaIndexEntity;
import com.biz.crm.achievement.service.ISfaIndexService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.sfa.achievement.req.SfaIndexReqVo;
import com.biz.crm.nebular.sfa.achievement.resp.SfaIndexRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author yangshan
 * @date 2021-2-23 19:45:01
 */
@Slf4j
@Service
@Transactional
public class SfaIndexServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaIndexMapper, SfaIndexEntity> implements ISfaIndexService {

    @Autowired
    private SfaIndexMapper sfaIndexMapper;

    /**
     * 列表
     * @param sfaIndexReqVo
     * @return
     */
    @Override
    public PageResult<SfaIndexRespVo> findList(SfaIndexReqVo sfaIndexReqVo) {
        Page<SfaIndexRespVo> page = new Page<>(sfaIndexReqVo.getPageNum(), sfaIndexReqVo.getPageSize());
        List<SfaIndexRespVo> list = sfaIndexMapper.findList(page,sfaIndexReqVo);
        for(SfaIndexRespVo respVo : list){
            respVo.setEnableStatusName(CrmEnableStatusEnum.getDesc(respVo.getEnableStatus()));
        }
        return PageResult.<SfaIndexRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();

    }

    /**
     * 新增
     * @param sfaIndexReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaIndexReqVo sfaIndexReqVo) {
        this.checkParam(sfaIndexReqVo);
        SfaIndexEntity entity = CrmBeanUtil.copy(sfaIndexReqVo, SfaIndexEntity.class);
        entity.setIndexCode(sfaIndexReqVo.getIndexCode());
        entity.setIndexName(sfaIndexReqVo.getIndexName());
        this.save(entity);
    }

    /**
     * 参数校验
     * @param sfaIndexReqVo
     */
    public void checkParam(SfaIndexReqVo sfaIndexReqVo){
        AssertUtils.isNotEmpty(sfaIndexReqVo.getIndexCode(), "指标编码为空");
        AssertUtils.isNotEmpty(sfaIndexReqVo.getIndexName(), "指标名称为空");
    }

    /**
     * 更新
     * @param sfaIndexReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaIndexReqVo sfaIndexReqVo) {
        AssertUtils.isNotEmpty(sfaIndexReqVo.getId(), "主键不能为空");
        this.checkParam(sfaIndexReqVo);
        AssertUtils.isNotNull(this.getById(sfaIndexReqVo.getId()), "数据已经不存在");
        SfaIndexEntity entity = CrmBeanUtil.copy(sfaIndexReqVo, SfaIndexEntity.class);
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids) {
        List<SfaIndexEntity> sfaIndexEntities = sfaIndexMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaIndexEntities)){
            sfaIndexEntities.forEach(o -> {
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaIndexEntities);
    }

    /**
     * 启用
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids) {
        List<SfaIndexEntity> sfaIndexEntities = sfaIndexMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaIndexEntities)){
            sfaIndexEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaIndexEntities);
    }

    /**
     * 禁用
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids) {
        List<SfaIndexEntity> sfaIndexEntities = sfaIndexMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaIndexEntities)){
            sfaIndexEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaIndexEntities);
    }
}
