package com.biz.crm.activity.controller;

import com.biz.crm.activity.service.ISfaActivityRangeService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityRangeReqVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityRangeRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 活动执行范围;
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Slf4j
@RestController
@RequestMapping("/sfaActivityRangeController")
@Api(tags = "活动执行范围;")
public class SfaActivityRangeController {
    @Autowired
    private ISfaActivityRangeService sfaActivityRangeService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaActivityRangeRespVo>> list(@RequestBody SfaActivityRangeReqVo sfaActivityRangeReqVo) {
        PageResult<SfaActivityRangeRespVo> result=sfaActivityRangeService.findList(sfaActivityRangeReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaActivityRangeRespVo> query(@RequestBody SfaActivityRangeReqVo sfaActivityRangeReqVo) {
        SfaActivityRangeRespVo respVo=sfaActivityRangeService.query(sfaActivityRangeReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaActivityRangeReqVo sfaActivityRangeReqVo) {
        sfaActivityRangeService.save(sfaActivityRangeReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaActivityRangeReqVo sfaActivityRangeReqVo) {
        sfaActivityRangeService.update(sfaActivityRangeReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaActivityRangeReqVo sfaActivityRangeReqVo) {
        sfaActivityRangeService.deleteBatch(sfaActivityRangeReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaActivityRangeReqVo sfaActivityRangeReqVo) {
        sfaActivityRangeService.enableBatch(sfaActivityRangeReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaActivityRangeReqVo sfaActivityRangeReqVo) {
        sfaActivityRangeService.disableBatch(sfaActivityRangeReqVo);
        return Result.ok("禁用成功");
    }
}
