package com.biz.crm.activity.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.activity.model.SfaActivityExecutionEntity;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityExecutionReqVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 活动执行;
 * 
 * @author lf
 * @date 2020-12-30 15:24:11
 */
public interface SfaActivityExecutionMapper extends BaseMapper<SfaActivityExecutionEntity> {
    /**
     * 列表
     * @param page
     * @param sfaActivityExecutionReqVo
     * @return
     */
    List<SfaActivityExecutionRespVo> findList(Page<SfaActivityExecutionRespVo> page, @Param("vo") SfaActivityExecutionReqVo sfaActivityExecutionReqVo);

    /**
     * 查询费用活动列表
     * @param page
     * @param reqVo
     * @return
     */
    List<SfaActivityExecutionRespVo> findCostList(Page<SfaActivityExecutionRespVo> page, @Param("vo") SfaVisitStepActivityExecutionReqVo reqVo);



}
