package com.biz.crm.activity.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 方案活动套餐;
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_activity_bg_setmeal")
@CrmTable(name = "sfa_activity_bg_setmeal",tableNote = "方案活动套餐")
public class SfaActivityBgSetmealEntity extends CrmExtTenEntity<SfaActivityBgSetmealEntity> {

    /**
     * 活动执行id
     */
    @CrmColumn(name = "activity_execution_id", length = 100,note = "活动执行id")
    private String activityExecutionId;

    /**
     * 套餐备注
     */
    @CrmColumn(name = "setmeal_remarks", length = 100,note = "套餐备注")
    private String setmealRemarks;
}
