package com.biz.crm.activity.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.elasticsearch.annotations.*;

import javax.persistence.Index;
import javax.persistence.Transient;
import java.util.StringJoiner;

/**
 * 活动执行;实体类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_activity_execution")
@ApiModel("活动数据")
@CrmTable(name = SfaActivityExecutionEntity.TABLE_NAME, tableNote = "活动数据", indexes = {
        @Index(name = SfaActivityExecutionEntity.TABLE_NAME + "_index1", columnList = "activity_start_time, activity_end_time"),
        @Index(name = SfaActivityExecutionEntity.TABLE_NAME + "_index2", columnList = "activity_code")})
public class SfaActivityExecutionEntity extends CrmExtTenEntity<SfaActivityExecutionEntity> {

    public static final String TABLE_NAME = "sfa_activity_execution";
    /**
     * 活动名称
     */
    @ApiModelProperty("活动名称")
    @CrmColumn(name = "activity_name", length = 100,note = "活动名称")
    private String activityName;

    /**
     * 活动类型(cost-费用活动,display-陈列活动,bg-方案活动)
     */
    @ApiModelProperty("活动类型")
    @CrmColumn(name = "activity_type", length = 100,note = "活动类型")
    private String activityType;

    /**
     * 活动编码
     */
    @ApiModelProperty("活动编码")
    @CrmColumn(name = "activity_code", length = 100,note = "活动编码")
    private String activityCode;

    /**
     * 活动状态(0-未开始,1-已开始,2-已结束)
     */
    @CrmColumn(name = "activity_status", length = 100,note = "活动状态(0-未开始,1-已开始,2-已结束)")
    @ApiModelProperty("活动状态")
    private String activityStatus;

    /**
     * 活动执行开始时间
     */
    @ApiModelProperty("活动执行开始时间")
    @CrmColumn(name = "activity_start_time", length = 100,note = "活动执行开始时间")
    private String activityStartTime;

    /**
     * 活动执行结束时间
     */
    @ApiModelProperty("活动执行结束时间")
    @CrmColumn(name = "activity_end_time", length = 100,note = "活动执行结束时间")
    private String activityEndTime;

    /**
     * 销售额
     */
    @ApiModelProperty("销售额")
    @CrmColumn(name = "sales_volume", length = 100,note = "销售额")
    private String salesVolume;

    /**
     * 申请金额
     */
    @ApiModelProperty("申请金额")
    @CrmColumn(name = "apply_amount", length = 100,note = "申请金额")
    private String applyAmount;

    /**
     * 活动要求(0-活动照,1-门头照,2-陈列照)
     */
    @ApiModelProperty("活动要求")
    @CrmColumn(name = "activity_require", length = 100,note = "活动要求(0-活动照,1-门头照,2-陈列照)")
    private String activityRequire;

    /**
     * 活动描述
     */
    @ApiModelProperty("活动描述")
    @CrmColumn(name = "activity_desc", length = 100,note = "活动描述")
    private String activityDesc;

    /**
     * 活动执行频率(天)
     */
    @ApiModelProperty("活动执行频率")
    @CrmColumn(name = "activity_frequency", length = 100,note = "活动执行频率(天)")
    private String activityFrequency;

    /**
     * 门店类型
     */
    @ApiModelProperty("门店类型")
    @CrmColumn(name = "terminal_type", length = 100,note = "活动名称")
    private String terminalType;

    /**
     * 人员账号
     */
    @ApiModelProperty("人员账号")
    @CrmColumn(name = "user_name", length = 100,note = "人员账号")
    private String userName;

    /**
     * 人员姓名
     */
    @ApiModelProperty("人员姓名")
    @CrmColumn(name = "real_name", length = 100,note = "人员姓名")
    private String realName;

    /**
     * 职位名称
     */
    @CrmColumn(name = "pos_name", length = 100,note = "职位名称")
    private String posName;

    /**
     * 职位编码
     */
    @CrmColumn(name = "pos_code", length = 100,note = "职位编码")
    private String posCode;

    /**
     * 组织名称
     */
    @CrmColumn(name = "org_name", length = 100,note = "组织名称")
    private String orgName;

    /**
     * 组织编码
     */
    @CrmColumn(name = "org_code", length = 100,note = "组织编码")
    private String orgCode;


    @CrmColumn(name = "act_changed", length = 2,note = "活动是否有变更-Y/N")
    private String actChanged;

    @CrmColumn(name = "last_resolve_end_date", length = 16,note = "上次解析活动明细的结束日期")
    private String lastResolveEndDate;

}
