package com.biz.crm.activity.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.activity.model.SfaActivityBgProductEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityBgProductReqVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityBgProductRespVo;

/**
 * 活动产品;接口
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
public interface ISfaActivityBgProductService extends IService<SfaActivityBgProductEntity> {

    /**
     * 列表
     * @param sfaActivityBgProductReqVo
     * @return PageResult<SfaActivityProductRespVo>
     */
    PageResult<SfaActivityBgProductRespVo> findList(SfaActivityBgProductReqVo sfaActivityBgProductReqVo);

    /**
     * 查询
     * @param sfaActivityBgProductReqVo
     * @return SfaActivityProductRespVo
     */
    SfaActivityBgProductRespVo query(SfaActivityBgProductReqVo sfaActivityBgProductReqVo);

    /**
     * 新增
     * @param sfaActivityBgProductReqVo
     * @return
     */
    void save(SfaActivityBgProductReqVo sfaActivityBgProductReqVo);

    /**
     * 更新
     * @param sfaActivityBgProductReqVo
     * @return
     */
    void update(SfaActivityBgProductReqVo sfaActivityBgProductReqVo);

    /**
     * 删除
     * @param sfaActivityBgProductReqVo
     * @return
     */
    void deleteBatch(SfaActivityBgProductReqVo sfaActivityBgProductReqVo);

    /**
     * 启用
     * @param sfaActivityBgProductReqVo
     * @return
     */
    void enableBatch(SfaActivityBgProductReqVo sfaActivityBgProductReqVo);

    /**
     * 禁用
     * @param sfaActivityBgProductReqVo
     * @return
     */
    void disableBatch(SfaActivityBgProductReqVo sfaActivityBgProductReqVo);
}

