package com.biz.crm.activity.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activity.mapper.SfaActivityBgProductMapper;
import com.biz.crm.activity.model.SfaActivityBgProductEntity;
import com.biz.crm.activity.service.ISfaActivityBgProductService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityBgProductReqVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityBgProductRespVo;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 活动产品;接口实现
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaActivityBgProductServiceExpandImpl")
public class SfaActivityBgProductServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaActivityBgProductMapper, SfaActivityBgProductEntity> implements ISfaActivityBgProductService {

    @Resource
    private SfaActivityBgProductMapper sfaActivityBgProductMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaActivityBgProductRespVo> findList(SfaActivityBgProductReqVo reqVo){
        Page<SfaActivityBgProductRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaActivityBgProductRespVo> list = sfaActivityBgProductMapper.findList(page, reqVo);
        return PageResult.<SfaActivityBgProductRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaActivityBgProductRespVo
     */
    @Override
    public SfaActivityBgProductRespVo query(SfaActivityBgProductReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaActivityBgProductReqVo reqVo){
        SfaActivityBgProductEntity entity = CrmBeanUtil.copy(reqVo,SfaActivityBgProductEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaActivityBgProductReqVo reqVo){
        SfaActivityBgProductEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaActivityBgProductReqVo reqVo){
        List<SfaActivityBgProductEntity> sfaActivityBgProductEntities = sfaActivityBgProductMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActivityBgProductEntities)){
            sfaActivityBgProductEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaActivityBgProductEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaActivityBgProductReqVo reqVo){
        //设置状态为启用
        List<SfaActivityBgProductEntity> sfaActivityBgProductEntities = sfaActivityBgProductMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActivityBgProductEntities)){
            sfaActivityBgProductEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaActivityBgProductEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaActivityBgProductReqVo reqVo){
        //设置状态为禁用
        List<SfaActivityBgProductEntity> sfaActivityBgProductEntities = sfaActivityBgProductMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActivityBgProductEntities)){
                sfaActivityBgProductEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaActivityBgProductEntities);
    }
}
