package com.biz.crm.actscheme.controller;

import com.biz.crm.actscheme.service.ISfaActSchemeService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.actscheme.req.SfaActSchemeReqVo;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemeRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 活动方案;
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Slf4j
@RestController
@RequestMapping("/sfaActSchemeController")
@Api(tags = "活动方案;")
public class SfaActSchemeController {
    @Autowired
    private ISfaActSchemeService sfaActSchemeService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaActSchemeRespVo>> list(@RequestBody SfaActSchemeReqVo sfaActSchemeReqVo) {
        PageResult<SfaActSchemeRespVo> result = sfaActSchemeService.findList(sfaActSchemeReqVo);
        return Result.ok(result);
    }


    /**
     * 通过id查询详情
     */
    @ApiOperation(value = "通过id查询详情")
    @GetMapping("/queryDetailById")
    @CrmLog
    public Result<SfaActSchemeRespVo> queryDetailById(@RequestParam String id) {
        SfaActSchemeRespVo respVo = sfaActSchemeService.queryDetailById(id);
        return Result.ok(respVo);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaActSchemeRespVo> query(@RequestBody SfaActSchemeReqVo sfaActSchemeReqVo) {
        SfaActSchemeRespVo respVo = sfaActSchemeService.query(sfaActSchemeReqVo);
        return Result.ok(respVo);
    }

    /**
     * 根据执行ID查询方案信息
     */
    @ApiOperation(value = "根据执行ID查询方案信息")
    @GetMapping("/findSchemeByExecutionId/{executionId}")
    @CrmLog
    public Result<SfaActSchemeRespVo> findSchemeByExecutionId(@PathVariable("executionId") String executionId) {
        SfaActSchemeRespVo result = sfaActSchemeService.findSchemeByExecutionId(executionId);
        return Result.ok(result);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaActSchemeReqVo sfaActSchemeReqVo) {
        sfaActSchemeService.save(sfaActSchemeReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaActSchemeReqVo sfaActSchemeReqVo) {
        Result result = sfaActSchemeService.isUpdate(sfaActSchemeReqVo);
        if (!result.isSuccess()) {
            return result;
        }
        sfaActSchemeService.update(sfaActSchemeReqVo);
        return Result.ok("修改成功");
    }

    @ApiOperation(value = "是否允许更新")
    @PostMapping("/isUpdate")
    @CrmLog
    public Result isUpdate(@RequestBody SfaActSchemeReqVo sfaActSchemeReqVo) {
        Result result = sfaActSchemeService.isUpdate(sfaActSchemeReqVo);
        return result;
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        sfaActSchemeService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        sfaActSchemeService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        sfaActSchemeService.disableBatch(ids);
        return Result.ok("禁用成功");
    }


    /**
     * 根据当前人员查询可申请的活动方案列表
     */
    @ApiOperation(value = "根据当前人员查询可申请的活动方案列表")
    @PostMapping("/findPosList")
    @CrmLog
    public Result<PageResult<SfaActSchemeRespVo>> findPosList(@RequestBody SfaActSchemeReqVo sfaActSchemeReqVo) {
        PageResult<SfaActSchemeRespVo> result = sfaActSchemeService.findPosList(sfaActSchemeReqVo);
        return Result.ok(result);
    }


}
