package com.biz.crm.actscheme.controller;

import com.biz.crm.actscheme.service.ISfaActSchemePosApplyService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.sfa.actscheme.req.SfaActSchemePosApplyReqVo;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemePosApplyRespVo;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemeTerminalRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsStopRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 方案活动申请;
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Slf4j
@RestController
@RequestMapping("/sfaActSchemePosApplyController")
@Api(tags = "方案活动申请;")
public class SfaActSchemePosApplyController {
    @Autowired
    private ISfaActSchemePosApplyService sfaActSchemePosApplyService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaActSchemePosApplyRespVo>> list(@RequestBody SfaActSchemePosApplyReqVo sfaActSchemePosApplyReqVo) {
        PageResult<SfaActSchemePosApplyRespVo> result = sfaActSchemePosApplyService.findList(sfaActSchemePosApplyReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value = "参与信息")
    @PostMapping("/parList")
    @CrmLog
    public Result<PageResult<SfaActSchemeTerminalRespVo>> parList(@RequestBody SfaActSchemePosApplyReqVo sfaActSchemePosApplyReqVo) {
        PageResult<SfaActSchemeTerminalRespVo> result = sfaActSchemePosApplyService.parList(sfaActSchemePosApplyReqVo);
        return Result.ok(result);
    }

    /**
     * 通过id查询详情
     */
    @ApiOperation(value = "通过id查询详情")
    @GetMapping("/queryDetailById")
    @CrmLog
    public Result<SfaActSchemePosApplyRespVo> queryDetailById(@RequestParam String id) {
        SfaActSchemePosApplyRespVo respVo = sfaActSchemePosApplyService.queryDetailById(id);
        return Result.ok(respVo);
    }

    /**
     * 活动对应参与列表
     *
     * @param reqVo
     * @return
     */
    @ApiOperation(value = "活动对应参与列表")
    @PostMapping("/findAsStopList")
    @CrmLog
    public Result<List<SfaAsStopRespVo>> findAsStopList(SfaActSchemePosApplyReqVo reqVo) {
        return Result.ok(sfaActSchemePosApplyService.findAsStopList(reqVo));
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaActSchemePosApplyRespVo> query(@RequestBody SfaActSchemePosApplyReqVo sfaActSchemePosApplyReqVo) {
        SfaActSchemePosApplyRespVo respVo = sfaActSchemePosApplyService.query(sfaActSchemePosApplyReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaActSchemePosApplyReqVo sfaActSchemePosApplyReqVo) {
        sfaActSchemePosApplyService.save(sfaActSchemePosApplyReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaActSchemePosApplyReqVo sfaActSchemePosApplyReqVo) {
        sfaActSchemePosApplyService.update(sfaActSchemePosApplyReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        sfaActSchemePosApplyService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        sfaActSchemePosApplyService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        sfaActSchemePosApplyService.disableBatch(ids);
        return Result.ok("禁用成功");
    }


    @ApiOperation(value = "结案")
    @PostMapping("/endCase")
    @CrmLog
    public Result endCase(@RequestBody List<String> ids) {
        sfaActSchemePosApplyService.endCase(ids);
        return Result.ok("结案成功");
    }

    @ApiOperation(value = "关闭")
    @PostMapping("/close")
    @CrmLog
    public Result close(@RequestBody List<String> ids) {
        sfaActSchemePosApplyService.close(ids);
        return Result.ok("结案成功");
    }

    @ApiOperation(value = "工作流审批回调")
    @PostMapping("/callback")
    @CrmLog
    public Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        sfaActSchemePosApplyService.callback(activitiCallBackVo);
        return Result.ok();
    }
}
