package com.biz.crm.actscheme.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.actscheme.model.SfaActSchemePosApplyEntity;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.actscheme.req.SfaActSchemePosApplyReqVo;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemePosApplyRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 方案活动申请;
 * 
 * @author lf
 * @date 2020-12-30 15:24:11
 */
public interface SfaActSchemePosApplyMapper extends BaseMapper<SfaActSchemePosApplyEntity> {
    /**
     * 列表
     * @param page
     * @param sfaActSchemePosApplyReqVo
     * @return
     */
    @SqlPrivilege(orgCode = "org_code",posCode = "pos_code")
    List<SfaActSchemePosApplyRespVo> findList(Page<SfaActSchemePosApplyRespVo> page, @Param("vo") SfaActSchemePosApplyReqVo sfaActSchemePosApplyReqVo);


    /**
     * 查询方案活动执行列表
     * @param page
     * @param reqVo
     * @return
     */
    List<SfaActivityExecutionRespVo> findActSchemeList(Page<SfaActivityExecutionRespVo> page,@Param("vo") SfaVisitStepActivityExecutionReqVo reqVo);

    /**
     * 查询方案活动执行完成列表
     * @param page
     * @param reqVo
     * @return
     */
    List<SfaVisitStepActivityExecutionRespVo> findActSchemeCompleteList(Page<SfaVisitStepActivityExecutionRespVo> page, @Param("vo") SfaVisitStepActivityExecutionReqVo reqVo);


}
