package com.biz.crm.actscheme.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 活动方案;实体类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_act_scheme")
@CrmTable(name = "sfa_act_scheme", tableNote = "活动方案")
public class SfaActSchemeEntity extends CrmExtTenEntity<SfaActSchemeEntity> {


    /**
     * 方案名称
     */
    @CrmColumn(name = "scheme_name", length = 50, note = "方案名称")
    private String schemeName;

    /**
     * 方案编码
     */
    @CrmColumn(name = "scheme_code", length = 32, note = "方案编码")
    private String schemeCode;

    /**
     * 方案类型(1-陈列方案,2-常规促销,3-特渠促销)
     */
    @CrmColumn(name = "scheme_type", length = 10, note = "方案类型")
    private String schemeType;

    /**
     * 方案执行开始时间
     */
    @CrmColumn(name = "scheme_start_time", length = 32, note = "方案执行开始时间")
    private String schemeStartTime;

    /**
     * 方案执行结束时间
     */
    @CrmColumn(name = "scheme_end_time", length = 50, note = "方案执行结束时间")
    private String schemeEndTime;

    /**
     * 陈列类型
     */
    @CrmColumn(name = "display_type", length = 255, note = "陈列类型")
    private String displayType;

    /**
     * 门店类型
     */
    @CrmColumn(name = "terminal_type", length = 50, note = "门店类型")
    private String terminalType;

    /**
     * 方案描述
     */
    @CrmColumn(name = "scheme_desc", length = 200, note = "方案描述")
    private String schemeDesc;

    /**
     * 人员账号
     */
    @CrmColumn(name = "user_name", length = 50, note = "人员账号")
    private String userName;

    /**
     * 人员姓名
     */
    @CrmColumn(name = "real_name", length = 50, note = "人员姓名")
    private String realName;

    /**
     * 职位名称
     */
    @CrmColumn(name = "pos_name", length = 50, note = "职位名称")
    private String posName;

    /**
     * 职位编码
     */
    @CrmColumn(name = "pos_code", length = 50, note = "职位编码")
    private String posCode;

    /**
     * 组织名称
     */
    @CrmColumn(name = "org_name", length = 50, note = "组织名称")
    private String orgName;

    /**
     * 组织编码
     */
    @CrmColumn(name = "org_code", length = 50, note = "组织编码")
    private String orgCode;


}
