package com.biz.crm.actscheme.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 活动方案文件 实体类
 *
 * @author liuhongming
 * @date 2020-10-15 15:32:29
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_act_scheme_picture")
@CrmTable(name = "sfa_act_scheme_picture", tableNote = "活动方案文件")
public class SfaActSchemePictureEntity extends CrmExtTenEntity<SfaActSchemePictureEntity> {

    /**
     * 访问前缀
     */
    @CrmColumn(name = "url_path_prefix", length = 512, note = "访问前缀")
    private String urlPathPrefix;

    /**
     * 路径
     */
    @CrmColumn(name = "url_path", length = 512, note = "路径")
    private String urlPath;

    /**
     * 文件名称
     */
    @CrmColumn(name = "file_name", length = 200, note = "文件名称")
    private String fileName;

    /**
     * 对象名
     */
    @CrmColumn(name = "object_name", length = 512, note = "对象名")
    private String objectName;

    /**
     * 文件后缀
     */
    @CrmColumn(name = "suffix", length = 32, note = "文件后缀")
    private String suffix;

    /**
     * 方案id
     */
    @CrmColumn(name = "act_scheme_id", length = 32, note = "方案id")
    private String actSchemeId;

}
