package com.biz.crm.actscheme.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 方案活动申请;实体类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_act_scheme_pos_apply")
@CrmTable(name = "sfa_act_scheme_pos_apply", tableNote = "方案活动申请",indexes = {
        @Index(name ="act_scheme_pos_apply_index1",columnList = "ACTIVITY_CODE"),
        @Index(name ="act_scheme_pos_apply_index2",columnList = "scheme_code"),
})
public class SfaActSchemePosApplyEntity extends CrmExtTenEntity<SfaActSchemePosApplyEntity> {

    private static final long serialVersionUID = -795368283023668181L;
    /**
     * 方案编码
     */
    @CrmColumn(name = "scheme_code", length = 32, note = "方案名称")
    private String schemeCode;
    /**
     * 活动编码
     */
    @CrmColumn(name = "activity_code", length = 60, note = "活动编码")
    private String activityCode;
    /**
     * 活动名称
     */
    @CrmColumn(name = "activity_name", length = 50, note = "活动名称")
    private String activityName;
    /**
     * 活动类型
     */
    @CrmColumn(name = "activity_type", length = 32, note = "活动类型")
    private String activityType;
    /**
     * 门店类型
     */
    @CrmColumn(name = "terminal_type", length = 50, note = "门店类型")
    private String terminalType;
    /**
     * OA核销号
     */
    @CrmColumn(name = "oa_audit_code", length = 50, note = "OA核销号")
    private String oaAuditCode;
    /**
     * 活动费用
     */
    @CrmColumn(name = "act_cost_amount", length = 50, note = "活动费用")
    private String actCostAmount;
    /**
     * 计划销量
     */
    @CrmColumn(name = "plan_sales_volume", length = 50, note = "计划销量")
    private String planSalesVolume;
    /**
     * 单箱成本
     */
    @CrmColumn(name = "single_cost", length = 50, note = "单箱成本")
    private String singleCost;
    /**
     * 陈列类型
     */
    @CrmColumn(name = "display_type", length = 50, note = "陈列类型")
    private String displayType;
    /**
     * 计划投入门店数量
     */
    @CrmColumn(name = "plan_term_num", length = 50, note = "计划投入门店数量")
    private String planTermNum;
    /**
     * 兑付方式
     */
    @CrmColumn(name = "payment_method", length = 50, note = "兑付方式")
    private String paymentMethod;

    /**
     * 活动执行开始时间
     */
    @CrmColumn(name = "activity_start_time", length = 32, note = "活动执行开始时间")
    private String activityStartTime;

    /**
     * 活动执行结束时间
     */
    @CrmColumn(name = "activity_end_time", length = 32, note = "活动执行结束时间")
    private String activityEndTime;

    /**
     * 人员账号
     */
    @CrmColumn(name = "user_name", length = 50, note = "人员账号")
    private String userName;

    /**
     * 人员姓名
     */
    @CrmColumn(name = "real_name", length = 50, note = "人员姓名")
    private String realName;

    /**
     * 职位名称
     */
    @CrmColumn(name = "pos_name", length = 50, note = "职位名称")
    private String posName;

    /**
     * 职位编码
     */
    @CrmColumn(name = "pos_code", length = 50, note = "职位编码")
    private String posCode;

    /**
     * 组织名称
     */
    @CrmColumn(name = "org_name", length = 50, note = "组织名称")
    private String orgName;

    /**
     * 组织编码
     */
    @CrmColumn(name = "org_code", length = 50, note = "组织编码")
    private String orgCode;

    /**
     * 状态
     */
    @CrmColumn(name = "bpm_state", length = 32, note = "状态")
    private String bpmState;

    /**
     * 活动结案状态(0:正常；1：结案,2：关闭)
     */
    @CrmColumn(name = "end_case_state", length = 32, note = "活动结案状态")
    public String endCaseState;

    /**
     * 审批流程编码
     */
    @CrmColumn(name = "process_code", length = 32, note = "审批流程编码")
    public String processCode;
}
