package com.biz.crm.actscheme.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 活动方案产品;实体类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_act_scheme_product")
@CrmTable(name = "sfa_act_scheme_product", tableNote = "活动方案产品")
public class SfaActSchemeProductEntity extends CrmExtTenEntity<SfaActSchemeProductEntity> {

    /**
     * 方案id
     */
    @CrmColumn(name = "act_scheme_id", length = 32, note = "方案id")
    private String actSchemeId;

    /**
     * 套餐Id
     */
    @CrmColumn(name = "setmeal_id", length = 32, note = "套餐Id")
    private String setmealId;

    /**
     * 产品编码
     */
    @CrmColumn(name = "product_code", length = 32, note = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmColumn(name = "product_name", length = 50, note = "产品名称")
    private String productName;

    /**
     * 系列名称
     */
    @CrmColumn(name = "series_name", length = 50, note = "系列名称")
    private String seriesName;

    /**
     * 系列编码
     */
    @CrmColumn(name = "series_code", length = 50, note = "系列编码")
    private String seriesCode;

    /**
     * 行类型(1-本品,2-赠品)
     */
    @CrmColumn(name = "itme_type", length = 10, note = "行类型")
    private String itmeType;

}
