package com.biz.crm.actscheme.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 活动方案范围;实体类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_act_scheme_range")
@CrmTable(name = "sfa_act_scheme_range", tableNote = "活动方案范围")
public class SfaActSchemeRangeEntity extends CrmExtTenEntity<SfaActSchemeRangeEntity> {

    /**
     * 方案id
     */
    @CrmColumn(name = "act_scheme_id", length = 32, note = "方案id")
    private String actSchemeId;

    /**
     * 范围类型(0-组织,1-职位级别,2-职位)
     */
    @CrmColumn(name = "range_type", length = 3, note = "方案名称")
    private String rangeType;

    /**
     * 编码
     */
    @CrmColumn(name = "code", length = 32, note = "方案名称")
    private String code;

    /**
     * 名称
     */
    @CrmColumn(name = "name", length = 50, note = "方案名称")
    private String name;

}
