package com.biz.crm.actscheme.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 活动方案套餐;实体类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_act_scheme_setmeal")
@CrmTable(name = "sfa_act_scheme_setmeal", tableNote = "活动方案套餐")
public class SfaActSchemeSetmealEntity extends CrmExtTenEntity<SfaActSchemeSetmealEntity> {

    /**
     * 方案id
     */
    @CrmColumn(name = "act_scheme_id", length = 32, note = "方案编码")
    private String actSchemeId;

    /**
     * 顺序
     */
    @CrmColumn(name = "setmeal_order", length = 10, note = "方案编码")
    private String setmealOrder;

}
