package com.biz.crm.actscheme.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.actscheme.model.SfaActSchemeEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.actscheme.req.SfaActSchemeReqVo;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemeRespVo;
import com.biz.crm.util.Result;

import java.util.List;

/**
 * 活动执行;接口
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
public interface ISfaActSchemeService extends IService<SfaActSchemeEntity> {

    /**
     * 列表
     *
     * @param sfaActSchemeReqVo
     * @return PageResult<SfaActSchemeRespVo>
     */
    PageResult<SfaActSchemeRespVo> findList(SfaActSchemeReqVo sfaActSchemeReqVo);

    /**
     * 通过id查询详情
     *
     * @param id
     * @return
     */
    SfaActSchemeRespVo queryDetailById(String id);

    /**
     * 查询
     *
     * @param sfaActSchemeReqVo
     * @return SfaActSchemeRespVo
     */
    SfaActSchemeRespVo query(SfaActSchemeReqVo sfaActSchemeReqVo);

    /**
     * 新增
     *
     * @param sfaActSchemeReqVo
     * @return
     */
    void save(SfaActSchemeReqVo sfaActSchemeReqVo);

    /**
     * 更新
     *
     * @param sfaActSchemeReqVo
     * @return
     */
    void update(SfaActSchemeReqVo sfaActSchemeReqVo);

    /**
     * 是否允许更新
     *
     * @param sfaActSchemeReqVo
     * @return
     */
    Result isUpdate(SfaActSchemeReqVo sfaActSchemeReqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);

    /**
     * 根据当前人员查询可申请的活动方案列表
     *
     * @param reqVo
     * @return
     */
    PageResult<SfaActSchemeRespVo> findPosList(SfaActSchemeReqVo reqVo);

    /**
     * 移动端查询到活动方案明细
     *
     * @param id
     * @return
     */
    SfaActSchemeRespVo queryMobileDetailById(String id);

    /**
     * 根据执行ID查询方案信息
     *
     * @param executionId
     * @return
     */
    SfaActSchemeRespVo findSchemeByExecutionId(String executionId);
}

