package com.biz.crm.actscheme.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.actscheme.mapper.*;
import com.biz.crm.actscheme.model.*;
import com.biz.crm.actscheme.service.*;
import com.biz.crm.asexecution.mapper.SfaAsExecutionMapper;
import com.biz.crm.asexecution.model.SfaAsExecutionEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.activiti.act.TaProcessBizRelationEnum;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.sfa.actscheme.req.SfaActSchemeReqVo;
import com.biz.crm.nebular.sfa.actscheme.req.SfaActSchemeSetmealReqVo;
import com.biz.crm.nebular.sfa.actscheme.resp.*;
import com.biz.crm.util.*;
import com.google.common.base.Joiner;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 活动执行;接口实现
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "sfaActSchemeServiceExpandImpl")
@Transactional
public class SfaActSchemeServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaActSchemeMapper, SfaActSchemeEntity> implements ISfaActSchemeService {

    @Resource
    private SfaActSchemeMapper sfaActSchemeMapper;
    @Resource
    private SfaActSchemePictureMapper sfaActSchemePictureMapper;
    @Autowired
    private ISfaActSchemePictureService sfaActSchemePictureService;
    @Resource
    private SfaActSchemeProductMapper sfaActSchemeProductMapper;
    @Autowired
    private ISfaActSchemeProductService sfaActSchemeProductService;
    @Resource
    private SfaActSchemeRangeMapper sfaActSchemeRangeMapper;
    @Autowired
    private ISfaActSchemeRangeService sfaActSchemeRangeService;
    @Resource
    private SfaActSchemeSetmealMapper sfaActSchemeSetmealMapper;
    @Autowired
    private ISfaActSchemeSetmealService sfaActSchemeSetmealService;
    @Autowired
    private ISfaActSchemePosApplyService sfaActSchemePosApplyService;
    @Resource
    private SfaAsExecutionMapper sfaAsExecutionMapper;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    @CrmDictMethod
    public PageResult<SfaActSchemeRespVo> findList(SfaActSchemeReqVo reqVo) {
        Page<SfaActSchemeRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaActSchemeRespVo> list = sfaActSchemeMapper.findList(page, reqVo);
        Map<String, String> displayMap = DictUtil.dictMap(DictConstant.DISPLAY_TYPE);
        Map<String, String> terminalMap = DictUtil.dictMap(DictConstant.TERMINAL_TYPE);
        for (SfaActSchemeRespVo sfaActSchemeRespVo : list) {
            if (StringUtils.isNotEmpty(sfaActSchemeRespVo.getDisplayType())) {
                List<String> displayTypeList = Arrays.asList(sfaActSchemeRespVo.getDisplayType().split(","));
                sfaActSchemeRespVo.setDisplayTypeList(displayTypeList);
                List<String> displayTypeDescList = new ArrayList<>();
                for (String displayType : displayTypeList) {
                    if (displayMap.containsKey(displayType)) {
                        displayTypeDescList.add(displayMap.get(displayType));
                    } else {
                        displayTypeDescList.add(displayType);
                    }
                }
                String displayTypeDesc = Joiner.on(",").join(displayTypeDescList);
                sfaActSchemeRespVo.setDisplayTypeDesc(displayTypeDesc);
                sfaActSchemeRespVo.setDisplayTypeDescList(displayTypeDescList);
            }
            if (StringUtils.isNotEmpty(sfaActSchemeRespVo.getTerminalType())) {
                List<String> terminalTypeList = Arrays.asList(sfaActSchemeRespVo.getTerminalType().split(","));
                sfaActSchemeRespVo.setTerminalTypeList(terminalTypeList);
                List<String> terminalTypeDescList = new ArrayList<>();
                for (String terminalType : terminalTypeList) {
                    if (terminalMap.containsKey(terminalType)) {
                        terminalTypeDescList.add(terminalMap.get(terminalType));
                    } else {
                        terminalTypeDescList.add(terminalType);
                    }
                }
                String terminalTypeDesc = Joiner.on(",").join(terminalTypeDescList);
                sfaActSchemeRespVo.setTerminalTypeDesc(terminalTypeDesc);
                sfaActSchemeRespVo.setTerminalTypeDescList(terminalTypeDescList);
            }
        }
        return PageResult.<SfaActSchemeRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }


    /**
     * 通过id查询详情
     *
     * @param id
     * @return
     */
    @Override
    @CrmDictMethod
    public SfaActSchemeRespVo queryDetailById(String id) {
        AssertUtils.isNotEmpty(id, "数据主键id不能为空");
        SfaActSchemeEntity sfaActSchemeEntity = this.lambdaQuery().eq(SfaActSchemeEntity::getId, id).one();
        if (sfaActSchemeEntity == null) {
            throw new BusinessException("未查询到活动方案明细");
        }
        SfaActSchemeRespVo sfaActSchemeRespVo = CrmBeanUtil.copy(sfaActSchemeEntity, SfaActSchemeRespVo.class);
        if (StringUtils.isNotEmpty(sfaActSchemeRespVo.getDisplayType())) {
            List<String> displayTypeList = Arrays.asList(sfaActSchemeRespVo.getDisplayType().split(","));
            sfaActSchemeRespVo.setDisplayTypeList(displayTypeList);
            Map<String, String> displayMap = DictUtil.dictMap(DictConstant.DISPLAY_TYPE);
            List<String> displayTypeDescList = new ArrayList<>();
            Map<String, String> displayTypeMap = new HashMap<>();
            for (String displayType : displayTypeList) {
                if (displayMap.containsKey(displayType)) {
                    displayTypeDescList.add(displayMap.get(displayType));
                    displayTypeMap.put(displayType, displayMap.get(displayType));
                } else {
                    displayTypeDescList.add(displayType);
                    displayTypeMap.put(displayType, displayType);
                }
            }
            String displayTypeDesc = Joiner.on(",").join(displayTypeDescList);
            sfaActSchemeRespVo.setDisplayTypeDesc(displayTypeDesc);
            sfaActSchemeRespVo.setDisplayTypeDescList(displayTypeDescList);
            sfaActSchemeRespVo.setDisplayTypeMap(displayTypeMap);
        }

        if (StringUtils.isNotEmpty(sfaActSchemeRespVo.getTerminalType())) {
            List<String> terminalTypeList = Arrays.asList(sfaActSchemeRespVo.getTerminalType().split(","));
            sfaActSchemeRespVo.setTerminalTypeList(terminalTypeList);
            Map<String, String> terminalMap = DictUtil.dictMap(DictConstant.TERMINAL_TYPE);
            List<String> terminalTypeDescList = new ArrayList<>();
            Map<String, String> terminalTypeMap = new HashMap<>();
            for (String terminalType : terminalTypeList) {
                if (terminalMap.containsKey(terminalType)) {
                    terminalTypeDescList.add(terminalMap.get(terminalType));
                    terminalTypeMap.put(terminalType, terminalMap.get(terminalType));
                } else {
                    terminalTypeDescList.add(terminalType);
                    terminalTypeMap.put(terminalType, terminalType);
                }
            }
            String terminalTypeDesc = Joiner.on(",").join(terminalTypeDescList);
            sfaActSchemeRespVo.setTerminalTypeDesc(terminalTypeDesc);
            sfaActSchemeRespVo.setTerminalTypeDescList(terminalTypeDescList);
            sfaActSchemeRespVo.setTerminalTypeMap(terminalTypeMap);
        }


        LambdaQueryWrapper<SfaActSchemeRangeEntity> rangeQueryWrapper = new LambdaQueryWrapper<SfaActSchemeRangeEntity>()
                .eq(SfaActSchemeRangeEntity::getActSchemeId, id);
        List<SfaActSchemeRangeEntity> rangeEntityList = sfaActSchemeRangeMapper.selectList(rangeQueryWrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero(rangeEntityList)) {
            List<SfaActSchemeRangeRespVo> rangeRespVos = CrmBeanUtil.copyList(rangeEntityList, SfaActSchemeRangeRespVo.class);
            sfaActSchemeRespVo.setActSchemeRangeList(rangeRespVos);
        }

        LambdaQueryWrapper<SfaActSchemePictureEntity> pictureQueryWrapper = new LambdaQueryWrapper<SfaActSchemePictureEntity>()
                .eq(SfaActSchemePictureEntity::getActSchemeId, id);
        List<SfaActSchemePictureEntity> pictureEntities = sfaActSchemePictureMapper.selectList(pictureQueryWrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero(pictureEntities)) {
            List<SfaActSchemePictureRespVo> pictureRespVos = CrmBeanUtil.copyList(pictureEntities, SfaActSchemePictureRespVo.class);
            sfaActSchemeRespVo.setActSchemePictureList(pictureRespVos);
        }

        LambdaQueryWrapper<SfaActSchemeSetmealEntity> setmealQueryWrapper = new LambdaQueryWrapper<SfaActSchemeSetmealEntity>()
                .eq(SfaActSchemeSetmealEntity::getActSchemeId, id).orderByAsc(SfaActSchemeSetmealEntity::getSetmealOrder);
        List<SfaActSchemeSetmealEntity> setmealEntityList = sfaActSchemeSetmealMapper.selectList(setmealQueryWrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero(setmealEntityList)) {
            List<SfaActSchemeSetmealRespVo> actSchemeSetmealList = CrmBeanUtil.copyList(setmealEntityList, SfaActSchemeSetmealRespVo.class);

            LambdaQueryWrapper<SfaActSchemeProductEntity> productQueryWrapper = new LambdaQueryWrapper<SfaActSchemeProductEntity>()
                    .eq(SfaActSchemeProductEntity::getActSchemeId, id);
            List<SfaActSchemeProductEntity> productEntityList = sfaActSchemeProductMapper.selectList(productQueryWrapper);
            List<SfaActSchemeProductRespVo> actSchemeProductList = CrmBeanUtil.copyList(productEntityList, SfaActSchemeProductRespVo.class);
            Map<String, List<SfaActSchemeProductRespVo>> mapRange = actSchemeProductList.stream().collect(Collectors.groupingBy(SfaActSchemeProductRespVo::getSetmealId));
            for (SfaActSchemeSetmealRespVo actSchemeSetmeal : actSchemeSetmealList) {
                if (mapRange.containsKey(actSchemeSetmeal.getId())) {
                    List<SfaActSchemeProductRespVo> productRespVoList = mapRange.get(actSchemeSetmeal.getId());
                    Map<String, List<SfaActSchemeProductRespVo>> mapProductRange = productRespVoList.stream().collect(Collectors.groupingBy(SfaActSchemeProductRespVo::getItmeType));
                    if (mapProductRange.containsKey(SfaActivityEnum.bpItemType.bp.getVal())) {
                        actSchemeSetmeal.setBpSchemeProductList(mapProductRange.get(SfaActivityEnum.bpItemType.bp.getVal()));
                    }
                    if (mapProductRange.containsKey(SfaActivityEnum.bpItemType.zp.getVal())) {
                        actSchemeSetmeal.setZpSchemeProductList(mapProductRange.get(SfaActivityEnum.bpItemType.zp.getVal()));
                    }
                    actSchemeSetmeal.setActSchemeProductList(productRespVoList);
                }
            }
            sfaActSchemeRespVo.setActSchemeSetmealList(actSchemeSetmealList);
        }

        List<SfaActSchemePosApplyEntity> actSchemePosApplyList = sfaActSchemePosApplyService.lambdaQuery()
                .eq(SfaActSchemePosApplyEntity::getSchemeCode, sfaActSchemeRespVo.getSchemeCode())
                .and(x -> x.eq(SfaActSchemePosApplyEntity::getBpmState, TaProcessBizRelationEnum.bpmStatus.PASS.getValue()).or().eq(SfaActSchemePosApplyEntity::getBpmState, TaProcessBizRelationEnum.bpmStatus.APPROVAL.getValue()))
                .eq(SfaActSchemePosApplyEntity::getDelFlag, CrmEnableStatusEnum.ENABLE.getCode())
                .eq(SfaActSchemePosApplyEntity::getEndCaseState, CrmEnableStatusEnum.ENABLE.getCode()).list();
        if (CollectionUtil.listNotEmptyNotSizeZero(actSchemePosApplyList)) {
            List<SfaActSchemePosApplyRespVo> actSchemePosApplyRespVos = CrmBeanUtil.copyList(actSchemePosApplyList, SfaActSchemePosApplyRespVo.class);
            sfaActSchemeRespVo.setActSchemePosApplyList(actSchemePosApplyRespVos);
        }
        sfaActSchemeRespVo.setPaymentMethodMap(SfaActivityEnum.paymentMethod.GETMAP);
        return sfaActSchemeRespVo;
    }

    /**
     * 查询
     *
     * @param reqVo
     * @return sfaActivityExecutionRespVo
     */
    @Override
    public SfaActSchemeRespVo query(SfaActSchemeReqVo reqVo) {
        return null;
    }

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaActSchemeReqVo reqVo) {
        //参数校验
        this.checkParam(reqVo);
        SfaActSchemeEntity entity = CrmBeanUtil.copy(reqVo, SfaActSchemeEntity.class);
        entity.setSchemeCode(CodeUtil.generateCode(SfaCodeEnum.schemeCode.SCHEME_CODE.getVal()));
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save(entity);
        String actSchemeId = entity.getId();
        reqVo.getActSchemeRangeList().forEach(data -> {
            data.setActSchemeId(actSchemeId);
        });
        List<SfaActSchemeRangeEntity> activityRangeEntityList = CrmBeanUtil.copyList(reqVo.getActSchemeRangeList(), SfaActSchemeRangeEntity.class);
        sfaActSchemeRangeService.saveBatch(activityRangeEntityList);
        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getActSchemePictureList())) {
            List<SfaActSchemePictureEntity> sfaActSchemePictureEntities = CrmBeanUtil.copyList(reqVo.getActSchemePictureList(), SfaActSchemePictureEntity.class);
            sfaActSchemePictureEntities.forEach(data -> {
                data.setActSchemeId(actSchemeId);
            });
            sfaActSchemePictureService.saveBatch(sfaActSchemePictureEntities);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getActSchemeSetmealList())) {
            for (SfaActSchemeSetmealReqVo setmealReqVo : reqVo.getActSchemeSetmealList()) {
                SfaActSchemeSetmealEntity setmealEntity = CrmBeanUtil.copy(setmealReqVo, SfaActSchemeSetmealEntity.class);
                setmealEntity.setActSchemeId(actSchemeId);
                sfaActSchemeSetmealService.save(setmealEntity);
                if (CollectionUtil.listNotEmptyNotSizeZero(setmealReqVo.getActSchemeProductList())) {
                    List<SfaActSchemeProductEntity> activityBgProductEntities = CrmBeanUtil.copyList(setmealReqVo.getActSchemeProductList(), SfaActSchemeProductEntity.class);
                    activityBgProductEntities.forEach(data -> {
                        data.setActSchemeId(actSchemeId);
                        data.setSetmealId(setmealEntity.getId());
                    });
                    sfaActSchemeProductService.saveBatch(activityBgProductEntities);
                }
            }
        }
    }


    /**
     * 校验参数信息
     *
     * @param reqVo
     */
    private void checkParam(SfaActSchemeReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        AssertUtils.isNotEmpty(reqVo.getSchemeName(), "方案名称为空");
        AssertUtils.isNotEmpty(reqVo.getSchemeStartTime(), "方案开始时间为空");
        AssertUtils.isNotEmpty(reqVo.getSchemeEndTime(), "方案结束时间为空");
        AssertUtils.isNotEmpty(reqVo.getActSchemeSetmealList(), "活动方案套餐为空");
        AssertUtils.isNotEmpty(reqVo.getActSchemeRangeList(), "活动方案范围为空");

        AssertUtils.isNotEmpty(reqVo.getDisplayTypeList(), "陈列类型为空");
        reqVo.setDisplayType(Joiner.on(",").join(reqVo.getDisplayTypeList()));
        AssertUtils.isNotEmpty(reqVo.getTerminalTypeList(), "门店类型为空");
        reqVo.setTerminalType(Joiner.on(",").join(reqVo.getTerminalTypeList()));
        LocalDate activityStartTime = null;
        LocalDate activityEndTime = null;
        LocalDate now = LocalDate.now();
        try {
            activityStartTime = LocalDate.parse(reqVo.getSchemeStartTime());
            activityEndTime = LocalDate.parse(reqVo.getSchemeEndTime());
        } catch (Exception e) {
            throw new BusinessException("方案时间错误");
        }
        if (!activityStartTime.isBefore(activityEndTime)) {
            throw new BusinessException("方案开始时间不能大于方案结束时间");
        }
        if (now.isAfter(activityEndTime)) {
            throw new BusinessException("方案结束时间不可小于当前时间");
        }
        int i = 1;
        for (SfaActSchemeSetmealReqVo data : reqVo.getActSchemeSetmealList()) {
            data.setSetmealOrder(String.valueOf(i));
            AssertUtils.isNotEmpty(data.getActSchemeProductList(), "套餐" + i + ",活动方案产品为空");
            i++;
        }
        reqVo.getActSchemeRangeList().forEach(data -> {
            if (!SfaActivityEnum.actSchemeRangeType.GETMAP.containsKey(data.getRangeType())) {
                throw new BusinessException("方案范围类型错误");
            }
            AssertUtils.isNotEmpty(data.getCode(), "编码为空");
            AssertUtils.isNotEmpty(data.getName(), "名称为空");
        });
        reqVo.setUserName(user.getUsername());
        reqVo.setRealName(user.getRealname());
        reqVo.setPosCode(user.getPoscode());
        reqVo.setPosName(user.getPosname());
        reqVo.setOrgCode(user.getOrgcode());
        reqVo.setOrgName(user.getOrgname());
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaActSchemeReqVo reqVo) {
        //校验参数信息
        this.checkParam(reqVo);
        SfaActSchemeEntity entity = this.getById(reqVo.getId());
        String id = entity.getId();
        entity = CrmBeanUtil.copy(reqVo, SfaActSchemeEntity.class);
        entity.setId(id);
        this.updateById(entity);

        LambdaQueryWrapper<SfaActSchemeRangeEntity> rangeQueryWrapper = new LambdaQueryWrapper<SfaActSchemeRangeEntity>()
                .eq(SfaActSchemeRangeEntity::getActSchemeId, id);
        LambdaQueryWrapper<SfaActSchemePictureEntity> picQueryWrapper = new LambdaQueryWrapper<SfaActSchemePictureEntity>()
                .eq(SfaActSchemePictureEntity::getActSchemeId, id);
        LambdaQueryWrapper<SfaActSchemeSetmealEntity> bgSetmealQueryWrapper = new LambdaQueryWrapper<SfaActSchemeSetmealEntity>()
                .eq(SfaActSchemeSetmealEntity::getActSchemeId, id);
        LambdaQueryWrapper<SfaActSchemeProductEntity> productQueryWrapper = new LambdaQueryWrapper<SfaActSchemeProductEntity>()
                .eq(SfaActSchemeProductEntity::getActSchemeId, id);
        sfaActSchemeRangeMapper.delete(rangeQueryWrapper);
        sfaActSchemePictureMapper.delete(picQueryWrapper);
        sfaActSchemeSetmealMapper.delete(bgSetmealQueryWrapper);
        sfaActSchemeProductMapper.delete(productQueryWrapper);

        reqVo.getActSchemeRangeList().forEach(data -> {
            data.setActSchemeId(id);
        });
        List<SfaActSchemeRangeEntity> activityRangeEntityList = CrmBeanUtil.copyList(reqVo.getActSchemeRangeList(), SfaActSchemeRangeEntity.class);
        sfaActSchemeRangeService.saveBatch(activityRangeEntityList);
        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getActSchemePictureList())) {
            List<SfaActSchemePictureEntity> sfaVisitPictureEntities = CrmBeanUtil.copyList(reqVo.getActSchemePictureList(), SfaActSchemePictureEntity.class);
            sfaVisitPictureEntities.forEach(data -> {
                data.setActSchemeId(id);
            });
            sfaActSchemePictureService.saveBatch(sfaVisitPictureEntities);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getActSchemeSetmealList())) {
            for (SfaActSchemeSetmealReqVo setmealReqVo : reqVo.getActSchemeSetmealList()) {
                SfaActSchemeSetmealEntity setmealEntity = CrmBeanUtil.copy(setmealReqVo, SfaActSchemeSetmealEntity.class);
                setmealEntity.setActSchemeId(id);
                sfaActSchemeSetmealService.save(setmealEntity);
                if (CollectionUtil.listNotEmptyNotSizeZero(setmealReqVo.getActSchemeProductList())) {
                    List<SfaActSchemeProductEntity> activityBgProductEntities = CrmBeanUtil.copyList(setmealReqVo.getActSchemeProductList(), SfaActSchemeProductEntity.class);
                    activityBgProductEntities.forEach(data -> {
                        data.setActSchemeId(id);
                        data.setSetmealId(setmealEntity.getId());
                    });
                    sfaActSchemeProductService.saveBatch(activityBgProductEntities);
                }
            }
        }
    }

    /**
     * 是否允许更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Result isUpdate(SfaActSchemeReqVo reqVo) {
        Result result = Result.ok();
        SfaActSchemeEntity entity = this.getById(reqVo.getId());
        List<SfaActSchemePosApplyEntity> actSchemePosApplyList = sfaActSchemePosApplyService.lambdaQuery()
                .eq(SfaActSchemePosApplyEntity::getSchemeCode, entity.getSchemeCode())
                .and(x -> x.eq(SfaActSchemePosApplyEntity::getBpmState, TaProcessBizRelationEnum.bpmStatus.PASS.getValue()).or().eq(SfaActSchemePosApplyEntity::getBpmState, TaProcessBizRelationEnum.bpmStatus.APPROVAL.getValue()))
                .eq(SfaActSchemePosApplyEntity::getDelFlag, CrmEnableStatusEnum.ENABLE.getCode())
                .eq(SfaActSchemePosApplyEntity::getEndCaseState, CrmEnableStatusEnum.ENABLE.getCode()).list();
        if (CollectionUtil.listNotEmptyNotSizeZero(actSchemePosApplyList)) {
            StringBuffer activityCodeBuffer = new StringBuffer();
            for (SfaActSchemePosApplyEntity actSchemePosApply : actSchemePosApplyList) {
                if (activityCodeBuffer.length() > 0) {
                    activityCodeBuffer.append(",");
                }
                activityCodeBuffer.append(actSchemePosApply.getActivityCode());
            }
            result = Result.error("方案已被活动申请[" + activityCodeBuffer.toString() + "]，不能编辑");
        }
        return result;
    }


    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("数据主键不能为空");
        }
        List<SfaActSchemeEntity> sfaActSchemeEntities = sfaActSchemeMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaActSchemeEntities)) {
            sfaActSchemeEntities.forEach(o -> {
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaActSchemeEntities);
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为启用
        List<SfaActSchemeEntity> sfaActSchemeEntities = sfaActSchemeMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaActSchemeEntities)) {
            sfaActSchemeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaActSchemeEntities);
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为禁用
        List<SfaActSchemeEntity> sfaActSchemeEntities = sfaActSchemeMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaActSchemeEntities)) {
            sfaActSchemeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaActSchemeEntities);
    }

    /**
     * 根据当前人员查询可申请的活动方案列表
     *
     * @param reqVo
     * @return
     */
    @Override
    @CrmDictMethod
    public PageResult<SfaActSchemeRespVo> findPosList(SfaActSchemeReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        String poscode = user.getPoscode();
        String posLevelcode = null;
        if (StringUtils.isNotEmpty(poscode)) {
            MdmPositionRespVo mdmPositionRespVo = PositionUtil.getPositionByCode(poscode);
            posLevelcode = mdmPositionRespVo.getPositionLevelCode();
        }
        String orgcode = user.getOrgcode();
        Page<SfaActSchemeRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<String> codeList = new ArrayList<>();
        //防止为空
        codeList.add("NOT");
        if (StringUtils.isNotEmpty(poscode)) {
            codeList.add(poscode);
        }
        if (StringUtils.isNotEmpty(posLevelcode)) {
            codeList.add(posLevelcode);
        }
        if (StringUtils.isNotEmpty(orgcode)) {
            codeList.add(orgcode);
        }
        if (!CollectionUtil.listNotEmptyNotSizeZero(codeList)) {
            return PageResult.<SfaActSchemeRespVo>builder()
                    .data(new ArrayList<>())
                    .count(Long.valueOf(0))
                    .build();
        }
        reqVo.setCodeList(codeList);
        reqVo.setPosCode(poscode);
        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        reqVo.setNow(now);
        List<SfaActSchemeRespVo> list = sfaActSchemeMapper.findPosList(page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List<String> ids = new ArrayList<>();
            for (SfaActSchemeRespVo sfaActSchemeRespVo : list) {
                ids.add(sfaActSchemeRespVo.getId());
            }
            LambdaQueryWrapper<SfaActSchemeSetmealEntity> setmealQueryWrapper = new LambdaQueryWrapper<SfaActSchemeSetmealEntity>()
                    .in(SfaActSchemeSetmealEntity::getActSchemeId, ids).orderByAsc(SfaActSchemeSetmealEntity::getSetmealOrder);
            List<SfaActSchemeSetmealEntity> setmealEntitys = sfaActSchemeSetmealMapper.selectList(setmealQueryWrapper);
            Map<String, List<SfaActSchemeSetmealEntity>> mapActSchemeSetmeal = setmealEntitys.stream().collect(Collectors.groupingBy(SfaActSchemeSetmealEntity::getActSchemeId));
            LambdaQueryWrapper<SfaActSchemeProductEntity> productQueryWrapper = new LambdaQueryWrapper<SfaActSchemeProductEntity>()
                    .in(SfaActSchemeProductEntity::getActSchemeId, ids);
            List<SfaActSchemeProductEntity> productEntitys = sfaActSchemeProductMapper.selectList(productQueryWrapper);
            Map<String, List<SfaActSchemeProductEntity>> mapActSchemeProduct = productEntitys.stream().collect(Collectors.groupingBy(SfaActSchemeProductEntity::getActSchemeId));
            Map<String, String> displayMap = DictUtil.dictMap(DictConstant.DISPLAY_TYPE);
            Map<String, String> terminalMap = DictUtil.dictMap(DictConstant.TERMINAL_TYPE);
            for (SfaActSchemeRespVo sfaActSchemeRespVo : list) {
                if (StringUtils.isNotEmpty(sfaActSchemeRespVo.getDisplayType())) {
                    List<String> displayTypeList = Arrays.asList(sfaActSchemeRespVo.getDisplayType().split(","));
                    sfaActSchemeRespVo.setDisplayTypeList(displayTypeList);
                    List<String> displayTypeDescList = new ArrayList<>();
                    for (String displayType : displayTypeList) {
                        if (displayMap.containsKey(displayType)) {
                            displayTypeDescList.add(displayMap.get(displayType));
                        } else {
                            displayTypeDescList.add(displayType);
                        }
                    }
                    String displayTypeDesc = Joiner.on(",").join(displayTypeDescList);
                    sfaActSchemeRespVo.setDisplayTypeDesc(displayTypeDesc);
                    sfaActSchemeRespVo.setDisplayTypeDescList(displayTypeDescList);
                }
                if (StringUtils.isNotEmpty(sfaActSchemeRespVo.getTerminalType())) {
                    List<String> terminalTypeList = Arrays.asList(sfaActSchemeRespVo.getTerminalType().split(","));
                    sfaActSchemeRespVo.setTerminalTypeList(terminalTypeList);
                    List<String> terminalTypeDescList = new ArrayList<>();
                    for (String terminalType : terminalTypeList) {
                        if (terminalMap.containsKey(terminalType)) {
                            terminalTypeDescList.add(terminalMap.get(terminalType));
                        } else {
                            terminalTypeDescList.add(terminalType);
                        }
                    }
                    String terminalTypeDesc = Joiner.on(",").join(terminalTypeDescList);
                    sfaActSchemeRespVo.setTerminalTypeDesc(terminalTypeDesc);
                    sfaActSchemeRespVo.setTerminalTypeDescList(terminalTypeDescList);
                }
                if (mapActSchemeSetmeal.containsKey(sfaActSchemeRespVo.getId())) {
                    List<SfaActSchemeSetmealEntity> setmealEntityList = mapActSchemeSetmeal.get(sfaActSchemeRespVo.getId());
                    List<SfaActSchemeSetmealRespVo> actSchemeSetmealList = CrmBeanUtil.copyList(setmealEntityList, SfaActSchemeSetmealRespVo.class);
                    List<SfaActSchemeProductEntity> productEntityList = new ArrayList<>();
                    if (mapActSchemeProduct.containsKey(sfaActSchemeRespVo.getId())) {
                        productEntityList = mapActSchemeProduct.get(sfaActSchemeRespVo.getId());
                    }
                    List<SfaActSchemeProductRespVo> actSchemeProductList = CrmBeanUtil.copyList(productEntityList, SfaActSchemeProductRespVo.class);
                    Map<String, List<SfaActSchemeProductRespVo>> mapRange = actSchemeProductList.stream().collect(Collectors.groupingBy(SfaActSchemeProductRespVo::getSetmealId));
                    for (SfaActSchemeSetmealRespVo actSchemeSetmeal : actSchemeSetmealList) {
                        if (mapRange.containsKey(actSchemeSetmeal.getId())) {
                            List<SfaActSchemeProductRespVo> productRespVoList = mapRange.get(actSchemeSetmeal.getId());
                            Map<String, List<SfaActSchemeProductRespVo>> mapProductRange = productRespVoList.stream().collect(Collectors.groupingBy(SfaActSchemeProductRespVo::getItmeType));
                            if (mapProductRange.containsKey(SfaActivityEnum.bpItemType.bp.getVal())) {
                                actSchemeSetmeal.setBpSchemeProductList(mapProductRange.get(SfaActivityEnum.bpItemType.bp.getVal()));
                            }
                            if (mapProductRange.containsKey(SfaActivityEnum.bpItemType.zp.getVal())) {
                                actSchemeSetmeal.setZpSchemeProductList(mapProductRange.get(SfaActivityEnum.bpItemType.zp.getVal()));
                            }
                            actSchemeSetmeal.setActSchemeProductList(productRespVoList);
                        }
                    }
                    sfaActSchemeRespVo.setActSchemeSetmealList(actSchemeSetmealList);
                }
            }
        }
        return PageResult.<SfaActSchemeRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 移动端查询到活动方案明细
     *
     * @param id
     * @return
     */
    @Override
    public SfaActSchemeRespVo queryMobileDetailById(String id) {
        AssertUtils.isNotEmpty(id, "数据主键id不能为空");
        SfaActSchemeEntity sfaActSchemeEntity = this.lambdaQuery().eq(SfaActSchemeEntity::getId, id).one();
        if (sfaActSchemeEntity == null) {
            throw new BusinessException("未查询到活动方案明细");
        }
        SfaActSchemeRespVo sfaActSchemeRespVo = CrmBeanUtil.copy(sfaActSchemeEntity, SfaActSchemeRespVo.class);

        //查询方案套餐
        LambdaQueryWrapper<SfaActSchemeSetmealEntity> setmealQueryWrapper = new LambdaQueryWrapper<SfaActSchemeSetmealEntity>()
                .eq(SfaActSchemeSetmealEntity::getActSchemeId, id).orderByAsc(SfaActSchemeSetmealEntity::getSetmealOrder);
        List<SfaActSchemeSetmealEntity> setmealEntityList = sfaActSchemeSetmealMapper.selectList(setmealQueryWrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero(setmealEntityList)) {
            List<SfaActSchemeSetmealRespVo> actSchemeSetmealList = CrmBeanUtil.copyList(setmealEntityList, SfaActSchemeSetmealRespVo.class);

            LambdaQueryWrapper<SfaActSchemeProductEntity> productQueryWrapper = new LambdaQueryWrapper<SfaActSchemeProductEntity>()
                    .eq(SfaActSchemeProductEntity::getActSchemeId, id);
            List<SfaActSchemeProductEntity> productEntityList = sfaActSchemeProductMapper.selectList(productQueryWrapper);
            List<SfaActSchemeProductRespVo> actSchemeProductList = CrmBeanUtil.copyList(productEntityList, SfaActSchemeProductRespVo.class);
            Map<String, List<SfaActSchemeProductRespVo>> mapRange = actSchemeProductList.stream().collect(Collectors.groupingBy(SfaActSchemeProductRespVo::getSetmealId));
            for (SfaActSchemeSetmealRespVo actSchemeSetmeal : actSchemeSetmealList) {
                if (mapRange.containsKey(actSchemeSetmeal.getId())) {
                    List<SfaActSchemeProductRespVo> productRespVoList = mapRange.get(actSchemeSetmeal.getId());
                    Map<String, List<SfaActSchemeProductRespVo>> mapProductRange = productRespVoList.stream().collect(Collectors.groupingBy(SfaActSchemeProductRespVo::getItmeType));
                    if (mapProductRange.containsKey(SfaActivityEnum.bpItemType.bp.getVal())) {
                        actSchemeSetmeal.setBpSchemeProductList(mapProductRange.get(SfaActivityEnum.bpItemType.bp.getVal()));
                    }
                    if (mapProductRange.containsKey(SfaActivityEnum.bpItemType.zp.getVal())) {
                        actSchemeSetmeal.setZpSchemeProductList(mapProductRange.get(SfaActivityEnum.bpItemType.zp.getVal()));
                    }
                    actSchemeSetmeal.setActSchemeProductList(productRespVoList);
                }
            }
            sfaActSchemeRespVo.setActSchemeSetmealList(actSchemeSetmealList);
        }
        return sfaActSchemeRespVo;
    }

    /**
     * 根据执行ID查询方案信息
     *
     * @param executionId
     * @return
     */
    @Override
    public SfaActSchemeRespVo findSchemeByExecutionId(String executionId) {
        SfaAsExecutionEntity executionEntity = sfaAsExecutionMapper.selectById(executionId);
        AssertUtils.isNotNull(executionEntity, "未查询到执行信息");
        //活动编码
        String activityCode = executionEntity.getActivityCode();
        //查询活动信息
        SfaActSchemePosApplyEntity schemePosApplyEntity = sfaActSchemePosApplyService.lambdaQuery()
                .eq(SfaActSchemePosApplyEntity::getActivityCode, activityCode).one();
        //方案编码
        String schemeCode = schemePosApplyEntity.getSchemeCode();
        //查询方案信息
        SfaActSchemeEntity sfaActSchemeEntity = this.lambdaQuery().eq(SfaActSchemeEntity::getSchemeCode, schemeCode).one();
        String id = sfaActSchemeEntity.getId();
        SfaActSchemeRespVo sfaActSchemeRespVo = CrmBeanUtil.copy(sfaActSchemeEntity, SfaActSchemeRespVo.class);

        //查询方案套餐
        LambdaQueryWrapper<SfaActSchemeSetmealEntity> setmealQueryWrapper = new LambdaQueryWrapper<SfaActSchemeSetmealEntity>()
                .eq(SfaActSchemeSetmealEntity::getActSchemeId, id).orderByAsc(SfaActSchemeSetmealEntity::getSetmealOrder);
        List<SfaActSchemeSetmealEntity> setmealEntityList = sfaActSchemeSetmealMapper.selectList(setmealQueryWrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero(setmealEntityList)) {
            List<SfaActSchemeSetmealRespVo> actSchemeSetmealList = CrmBeanUtil.copyList(setmealEntityList, SfaActSchemeSetmealRespVo.class);

            LambdaQueryWrapper<SfaActSchemeProductEntity> productQueryWrapper = new LambdaQueryWrapper<SfaActSchemeProductEntity>()
                    .eq(SfaActSchemeProductEntity::getActSchemeId, id);
            List<SfaActSchemeProductEntity> productEntityList = sfaActSchemeProductMapper.selectList(productQueryWrapper);
            List<SfaActSchemeProductRespVo> actSchemeProductList = CrmBeanUtil.copyList(productEntityList, SfaActSchemeProductRespVo.class);
            Map<String, List<SfaActSchemeProductRespVo>> mapRange = actSchemeProductList.stream().collect(Collectors.groupingBy(SfaActSchemeProductRespVo::getSetmealId));
            for (SfaActSchemeSetmealRespVo actSchemeSetmeal : actSchemeSetmealList) {
                if (mapRange.containsKey(actSchemeSetmeal.getId())) {
                    List<SfaActSchemeProductRespVo> productRespVoList = mapRange.get(actSchemeSetmeal.getId());
                    Map<String, List<SfaActSchemeProductRespVo>> mapProductRange = productRespVoList.stream().collect(Collectors.groupingBy(SfaActSchemeProductRespVo::getItmeType));
                    if (mapProductRange.containsKey(SfaActivityEnum.bpItemType.bp.getVal())) {
                        actSchemeSetmeal.setBpSchemeProductList(mapProductRange.get(SfaActivityEnum.bpItemType.bp.getVal()));
                    }
                    if (mapProductRange.containsKey(SfaActivityEnum.bpItemType.zp.getVal())) {
                        actSchemeSetmeal.setZpSchemeProductList(mapProductRange.get(SfaActivityEnum.bpItemType.zp.getVal()));
                    }
                    actSchemeSetmeal.setActSchemeProductList(productRespVoList);
                }
            }
            sfaActSchemeRespVo.setActSchemeSetmealList(actSchemeSetmealList);
        }
        return sfaActSchemeRespVo;
    }
}
