package com.biz.crm.acttask.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.acttask.service.ISfaActFileService;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActFileRespVo;
import com.biz.crm.nebular.sfa.acttask.req.SfaActFileReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 活动附件（示例图片） 
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */
@Slf4j
@RestController
@RequestMapping("/sfaactfile")
@Api(tags = "活动附件（示例图片） ")
public class SfaActFileController {
    @Autowired
    private ISfaActFileService sfaActFileService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaActFileRespVo>> list(@RequestBody SfaActFileReqVo sfaActFileReqVo) {
        PageResult<SfaActFileRespVo> result=sfaActFileService.findList(sfaActFileReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaActFileRespVo> query(@RequestBody SfaActFileReqVo sfaActFileReqVo) {
        SfaActFileRespVo respVo=sfaActFileService.query(sfaActFileReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaActFileReqVo sfaActFileReqVo) {
        sfaActFileService.save(sfaActFileReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaActFileReqVo sfaActFileReqVo) {
        sfaActFileService.update(sfaActFileReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaActFileReqVo sfaActFileReqVo) {
        sfaActFileService.deleteBatch(sfaActFileReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaActFileReqVo sfaActFileReqVo) {
        sfaActFileService.enableBatch(sfaActFileReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaActFileReqVo sfaActFileReqVo) {
        sfaActFileService.disableBatch(sfaActFileReqVo);
        return Result.ok("禁用成功");
    }
}
