package com.biz.crm.acttask.service;

import com.biz.crm.acttask.model.SfaActFileEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActFileRespVo;
import com.biz.crm.nebular.sfa.acttask.req.SfaActFileReqVo;

import java.util.Map;

/**
 * 活动附件（示例图片） 接口
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */
public interface ISfaActFileService extends IService<SfaActFileEntity> {

    /**
     * 列表
     * @param sfaActFileReqVo
     * @return PageResult<SfaActFileRespVo>
     */
    PageResult<SfaActFileRespVo> findList(SfaActFileReqVo sfaActFileReqVo);

    /**
     * 查询
     * @param sfaActFileReqVo
     * @return SfaActFileRespVo
     */
    SfaActFileRespVo query(SfaActFileReqVo sfaActFileReqVo);

    /**
     * 新增
     * @param sfaActFileReqVo
     * @return
     */
    void save(SfaActFileReqVo sfaActFileReqVo);

    /**
     * 更新
     * @param sfaActFileReqVo
     * @return
     */
    void update(SfaActFileReqVo sfaActFileReqVo);

    /**
     * 删除
     * @param sfaActFileReqVo
     * @return
     */
    void deleteBatch(SfaActFileReqVo sfaActFileReqVo);

    /**
     * 启用
     * @param sfaActFileReqVo
     * @return
     */
    void enableBatch(SfaActFileReqVo sfaActFileReqVo);

    /**
     * 禁用
     * @param sfaActFileReqVo
     * @return
     */
    void disableBatch(SfaActFileReqVo sfaActFileReqVo);
}

