package com.biz.crm.acttask.service;

import com.biz.crm.acttask.model.SfaActProductEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActProductRespVo;
import com.biz.crm.nebular.sfa.acttask.req.SfaActProductReqVo;

import java.util.Map;

/**
 * 活动任务管理-陈列要求 接口
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */
public interface ISfaActProductService extends IService<SfaActProductEntity> {

    /**
     * 列表
     * @param sfaActProductReqVo
     * @return PageResult<SfaActProductRespVo>
     */
    PageResult<SfaActProductRespVo> findList(SfaActProductReqVo sfaActProductReqVo);

    /**
     * 查询
     * @param sfaActProductReqVo
     * @return SfaActProductRespVo
     */
    SfaActProductRespVo query(SfaActProductReqVo sfaActProductReqVo);

    /**
     * 新增
     * @param sfaActProductReqVo
     * @return
     */
    void save(SfaActProductReqVo sfaActProductReqVo);

    /**
     * 更新
     * @param sfaActProductReqVo
     * @return
     */
    void update(SfaActProductReqVo sfaActProductReqVo);

    /**
     * 删除
     * @param sfaActProductReqVo
     * @return
     */
    void deleteBatch(SfaActProductReqVo sfaActProductReqVo);

    /**
     * 启用
     * @param sfaActProductReqVo
     * @return
     */
    void enableBatch(SfaActProductReqVo sfaActProductReqVo);

    /**
     * 禁用
     * @param sfaActProductReqVo
     * @return
     */
    void disableBatch(SfaActProductReqVo sfaActProductReqVo);
}

