package com.biz.crm.acttask.service;

import com.biz.crm.acttask.model.SfaActRangeEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActRangeRespVo;
import com.biz.crm.nebular.sfa.acttask.req.SfaActRangeReqVo;

import java.util.Map;

/**
 * 活动范围 接口
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */
public interface ISfaActRangeService extends IService<SfaActRangeEntity> {

    /**
     * 列表
     * @param sfaActRangeReqVo
     * @return PageResult<SfaActRangeRespVo>
     */
    PageResult<SfaActRangeRespVo> findList(SfaActRangeReqVo sfaActRangeReqVo);

    /**
     * 查询
     * @param sfaActRangeReqVo
     * @return SfaActRangeRespVo
     */
    SfaActRangeRespVo query(SfaActRangeReqVo sfaActRangeReqVo);

    /**
     * 新增
     * @param sfaActRangeReqVo
     * @return
     */
    void save(SfaActRangeReqVo sfaActRangeReqVo);

    /**
     * 更新
     * @param sfaActRangeReqVo
     * @return
     */
    void update(SfaActRangeReqVo sfaActRangeReqVo);

    /**
     * 删除
     * @param sfaActRangeReqVo
     * @return
     */
    void deleteBatch(SfaActRangeReqVo sfaActRangeReqVo);

    /**
     * 启用
     * @param sfaActRangeReqVo
     * @return
     */
    void enableBatch(SfaActRangeReqVo sfaActRangeReqVo);

    /**
     * 禁用
     * @param sfaActRangeReqVo
     * @return
     */
    void disableBatch(SfaActRangeReqVo sfaActRangeReqVo);
}

