package com.biz.crm.acttask.service;

import com.biz.crm.acttask.model.SfaActTaskEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActTaskRespVo;
import com.biz.crm.nebular.sfa.acttask.req.SfaActTaskReqVo;

import java.util.Map;

/**
 * 活动任务管理 接口
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */
public interface ISfaActTaskService extends IService<SfaActTaskEntity> {

    /**
     * 列表
     * @param sfaActTaskReqVo
     * @return PageResult<SfaActTaskRespVo>
     */
    PageResult<SfaActTaskRespVo> findList(SfaActTaskReqVo sfaActTaskReqVo);

    /**
     * 查询
     * @param sfaActTaskReqVo
     * @return SfaActTaskRespVo
     */
    SfaActTaskRespVo query(SfaActTaskReqVo sfaActTaskReqVo);

    /**
     * 新增
     * @param sfaActTaskReqVo
     * @return
     */
    void save(SfaActTaskReqVo sfaActTaskReqVo);

    /**
     * 更新
     * @param sfaActTaskReqVo
     * @return
     */
    void update(SfaActTaskReqVo sfaActTaskReqVo);

    /**
     * 删除
     * @param sfaActTaskReqVo
     * @return
     */
    void deleteBatch(SfaActTaskReqVo sfaActTaskReqVo);

    /**
     * 启用
     * @param sfaActTaskReqVo
     * @return
     */
    void enableBatch(SfaActTaskReqVo sfaActTaskReqVo);

    /**
     * 禁用
     * @param sfaActTaskReqVo
     * @return
     */
    void disableBatch(SfaActTaskReqVo sfaActTaskReqVo);
}

