package com.biz.crm.acttask.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.acttask.model.SfaActProductEntity;
import com.biz.crm.acttask.mapper.SfaActProductMapper;
import com.biz.crm.acttask.service.ISfaActProductService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActProductRespVo;
import com.biz.crm.nebular.sfa.acttask.req.SfaActProductReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;

import javax.annotation.Resource;

/**
 * 活动任务管理-陈列要求 接口实现
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaActProductServiceExpandImpl")
public class SfaActProductServiceImpl extends ServiceImpl<SfaActProductMapper, SfaActProductEntity> implements ISfaActProductService {

    @Resource
    private SfaActProductMapper sfaActProductMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaActProductRespVo> findList(SfaActProductReqVo reqVo){
        Page<SfaActProductRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaActProductRespVo> list = sfaActProductMapper.findList(page, reqVo);
        return PageResult.<SfaActProductRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaActProductRespVo
     */
    @Override
    public SfaActProductRespVo query(SfaActProductReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaActProductReqVo reqVo){
        SfaActProductEntity entity = CrmBeanUtil.copy(reqVo,SfaActProductEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaActProductReqVo reqVo){
        SfaActProductEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaActProductReqVo reqVo){
        List<SfaActProductEntity> sfaActProductEntities = sfaActProductMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActProductEntities)){
            sfaActProductEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaActProductEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaActProductReqVo reqVo){
        //设置状态为启用
        List<SfaActProductEntity> sfaActProductEntities = sfaActProductMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActProductEntities)){
            sfaActProductEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaActProductEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaActProductReqVo reqVo){
        //设置状态为禁用
        List<SfaActProductEntity> sfaActProductEntities = sfaActProductMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaActProductEntities)){
                sfaActProductEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaActProductEntities);
    }
}
