package com.biz.crm.ai.controller;

import com.biz.crm.ai.service.SfaAiTaskService;
import com.biz.crm.ai.vo.AiCallBackDto;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 陈列任务ai识别api
 *
 * @author sunx
 * @date 2021/9/26
 */
@Slf4j
@RestController
@RequestMapping("/ai/displayApiController")
@Api(tags = "陈列任务ai识别api;")
public class AiDisplayApiController {

  @Resource
  private SfaAiTaskService sfaAiTaskService;

  @PostMapping("/recognitionCallBack")
  @ApiOperation(value = "识别任务回调")
  @CrmLog
  public void recognitionCallBack(@RequestBody AiCallBackDto dto) {
    UserUtils.doTokenForNull();
    sfaAiTaskService.recognitionCallBack(dto);
  }

  @PostMapping("/repeatCallBack")
  @ApiOperation(value = "查重任务回调")
  @CrmLog
  public void repeatCallBack(@RequestBody AiCallBackDto dto) {
    UserUtils.doTokenForNull();
  }

  @GetMapping("/test")
  @ApiOperation(value = "手动触发")
  @CrmLog
  public void test(@RequestParam("taskId") String taskId, @RequestParam("status") String status) {
    UserUtils.doTokenForNull();
//    sfaAiTaskService.test(taskId, status);
  }
}
