package com.biz.crm.ai.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author sunx
 * @date 2021/9/26
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_ai_product")
@CrmTable(name = "sfa_ai_product", tableNote = "ai识别商品映射信息")
public class SfaAiProductEntity extends CrmBaseEntity<SfaAiProductEntity> {

  @CrmColumn(name = "product_code", length = 100, note = "商品编码")
  private String productCode;

  @CrmColumn(name = "product_name", length = 100, note = "商品名称")
  private String productName;

  @CrmColumn(name = "code", length = 100, note = "代号")
  private String code;
}
