package com.biz.crm.ai.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author sunx
 * @date 2021/9/26
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_ai_task_ext")
@CrmTable(name = "sfa_ai_task_ext", tableNote = "ai识别任务扩展信息")
public class SfaAiTaskExtEntity extends CrmBaseEntity<SfaAiTaskExtEntity> {

  @CrmColumn(name = "parent_id", length = 100, note = "ai识别任务信息id")
  private String parentId;

  @CrmColumn(name = "req_params_json", mysqlType = "LONGTEXT", oracleType = "CLOB", note = "陈列任务执行请求参数")
  private String reqParamsJson;

  @CrmColumn(name = "req_time", length = 20, note = "请求时间")
  private String reqTime;

  @CrmColumn(name = "recognition_json", mysqlType = "LONGTEXT", oracleType = "CLOB", note = "识别任务返回信息")
  private String recognitionJson;

  @CrmColumn(name = "recognition_time", length = 20, note = "识别回调时间")
  private String recognitionTime;

  @CrmColumn(name = "repeat_json", mysqlType = "LONGTEXT", oracleType = "CLOB", note = "查重返回信息")
  private String repeatJson;

  @CrmColumn(name = "repeat_time", length = 20, note = "查重回调时间")
  private String repeatTime;
}
