package com.biz.crm.ai.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.ai.mapper.SfaAiProductMapMapper;
import com.biz.crm.ai.model.SfaAiProductEntity;
import com.biz.crm.ai.service.SfaAiProductService;
import com.biz.crm.ai.vo.product.SfaAiProductVo;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

/**
 * @author sunx
 * @date 2021/9/26
 */
@Service
public class SfaAiProductServiceImpl<M extends BaseMapper<T>, T> extends
    ServiceImpl<SfaAiProductMapMapper, SfaAiProductEntity> implements
    SfaAiProductService {

  @Override
  public void bizSave(SfaAiProductVo vo) {
    SfaAiProductEntity entity = new SfaAiProductEntity();
    BeanUtils.copyProperties(vo, entity);
    this.saveOrUpdate(entity);
  }

  @Override
  public List<SfaAiProductVo> findAll() {
    List<SfaAiProductEntity> list = this.lambdaQuery().list();
    if (CollectionUtils.isEmpty(list)) {
      return Lists.newArrayList();
    }
    List<SfaAiProductVo> re = Lists.newArrayList();
    for (SfaAiProductEntity item : list) {
      SfaAiProductVo cur = new SfaAiProductVo();
      BeanUtils.copyProperties(item, cur);
      re.add(cur);
    }
    return re;
  }
}
