package com.biz.crm.ai.util;

import cn.hutool.core.map.MapUtil;
import cn.hutool.crypto.digest.MD5;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.TreeMap;
import lombok.extern.slf4j.Slf4j;

/**
 * @Author ldx
 * @Date 2021/9/14 11:04
 * @Description
 * @Version 1.0.0
 */
@Slf4j
public class AiRequestBase {

  // 3f903146dc90
  protected String appKey;
  // 674e98771e0d4669a1ba6234e405e127
  protected String appSecret;
  // 3506857863977547733
  protected String enterpriseId;

  protected final String AI_BASE_URL = "https://openapi.qa.ym.qq.com/gateway";
  protected final String AI_COS_API = "api.display.v1.uploadImg";
  protected final String AI_COS_API_VERSION = "1.0.0";
  protected final String AI_CREATE_LABEL_API = "api.display.v1.label.create";
  protected final String AI_CREATE_LABEL_API_VERSION = "1.0.0";
  protected final String AI_RECOGNITION_TASK_API = "api.display.v1.recognition.task";
  protected final String AI_RECOGNITION_TASK_API_VERSION = "1.0.0";
  protected final String AI_RECOGNITION_RESULT_API = "api.display.v1.recognition.result";
  protected final String AI_RECOGNITION_RESULT_API_VERSION = "1.0.0";
  protected final String AI_REPEAT_TASK_API = "api.display.v1.repeat.task";
  protected final String AI_REPEAT_TASK_API_VERSION = "1.0.0";
  protected final String AI_REPEAT_RESULT_API = "api.display.v1.repeat.result";
  protected final String AI_REPEAT_RESULT_API_VERSION = "1.0.0";
  protected final String SROP_VERSION = "1.0.0";

  protected String url(String api, String apiVersion, String body) {
    String time = String.valueOf(System.currentTimeMillis());
    Map<String, String> signMap = Maps.newHashMap();
    signMap.put("sropApi", api);
    signMap.put("sropApiVersion", apiVersion);
    signMap.put("sropAppKey", appKey);
    signMap.put("sropTimestamp", time);
    signMap.put("sropVersion", SROP_VERSION);
    signMap.put("sropRaw", body);

    TreeMap<String, String> treeMap = MapUtil.sort(signMap);

    StringBuilder preSignStr = new StringBuilder();
    int index = 0;
    for (Map.Entry<String, String> m : treeMap.entrySet()) {
      if (index == 0) {
        preSignStr.append(m.getKey() + "=" + m.getValue());
      } else {
        preSignStr.append("&" + m.getKey() + "=" + m.getValue());
      }
      index++;
    }

    String s = appSecret + preSignStr.toString() + appSecret;
    String sign = MD5.create().digestHex(s);

    return AI_BASE_URL + "?sropAppKey=" + appKey + "&sropApi=" + api + "&sropApiVersion="
        + apiVersion + "&sropSign=" + sign + "&sropTimestamp=" + time + "&sropVersion="
        + SROP_VERSION;
  }
}
