package com.biz.crm.ai.util;

import com.biz.crm.ai.vo.AiResult;
import com.biz.crm.util.StringUtils;

/**
 * @author sunx
 * @date 2021/9/26
 */
public class AiResultUtil {

  public static boolean checkResult(AiResult json) {
    if (json != null) {
      return json.getSuccess();
    }
    return false;
  }

  //返回对象集合信息
  public static <T> T objResult(AiResult<T> json) {
    return objResult(json, false);
  }

  /**
   * @param json
   * @param notNull true 返回success必须为true 否则报异常
   * @param <T>
   * @return
   */
  public static <T> T objResult(AiResult<T> json, boolean notNull) {
    if (checkResult(json)) {
      return json.getData();
    }
    if (notNull) {
      if (StringUtils.isNotEmpty(json.getMsg())) {
        throw new RuntimeException(json.getMsg());
      }
    }
    return json.getData();
  }
}
