package com.biz.crm.ai.util;

import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.map.MapUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import com.biz.crm.ai.vo.AiResult;
import com.biz.crm.ai.vo.label.LabelCreateVo;
import com.biz.crm.ai.vo.recognition.result.RecognitionResultVo;
import com.biz.crm.ai.vo.recognition.task.ImgInfo;
import com.biz.crm.ai.vo.recognition.task.ImgLibInfo;
import com.biz.crm.ai.vo.recognition.task.Recognition;
import com.biz.crm.ai.vo.recognition.task.RecognitionTaskDto;
import com.biz.crm.ai.vo.recognition.task.RecognitionTaskVo;
import com.biz.crm.ai.vo.repeat.result.RepeatResultVo;
import com.biz.crm.ai.vo.repeat.task.RepeatTaskDto;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

/**
 * @Author ldx
 * @Date 2021/9/14 17:11
 * @Description
 * @Version 1.0.0
 */
@Slf4j
public class AiUtil extends AiRequestBase {

  public static AiBuilder aiBuilder() {
    return new AiBuilder();
  }

  public String cosApi() {
    Map<String, String> param = MapUtil
        .builder(new HashMap<String, String>())
        .put("enterpriseId", enterpriseId)
        .build();
    String executeUrl = url(AI_COS_API, AI_COS_API_VERSION, JSONUtil.toJsonStr(param));
    log.info("executeUrl:{},param:{}", executeUrl, JSONUtil.toJsonStr(param));
    try {
      HttpResponse execute = HttpRequest.post(executeUrl)
          .body(JSONUtil.toJsonStr(param))
          .execute();
      log.info(execute.body());
      return execute.body();
    } catch (Exception e) {
      log.info("请求AI临时密钥失败:{}", JSONUtil.toJsonStr(param));
      return null;
    }
  }

  /**
   * 创建识别库
   *
   * @param labels
   * @return
   */
  public LabelCreateVo createLabel(List<String> labels, String enterpriseId) {
    Map<String, Object> param = MapUtil
        .builder(new HashMap<String, Object>())
        .put("enterpriseId", enterpriseId)
        .put("labels", labels)
        .build();
    String executeUrl = url(AI_CREATE_LABEL_API, AI_CREATE_LABEL_API_VERSION,
        JSONUtil.toJsonStr(param));
    log.info("executeUrl:{},param:{}", executeUrl, JSONUtil.toJsonStr(param));
    try {
      HttpResponse execute = HttpRequest.post(executeUrl)
          .body(JSONUtil.toJsonStr(param))
          .execute();
      log.info("\r\n createLabel->{}\r\n", execute.body());
      AiResult<LabelCreateVo> result = JSONUtil
          .toBean(execute.body(), new TypeReference<AiResult<LabelCreateVo>>() {
          }, false);
      return AiResultUtil.objResult(result, true);
    } catch (Exception e) {
      log.error("请求AI创建查重库失败:{},{}", JSONUtil.toJsonStr(param), e);
      return null;
    }
  }

  /**
   * 识别任务提交all
   *
   * @param dto
   * @return
   */
  public RecognitionResultVo execRecognitionTask(RecognitionTaskDto dto) {
    RecognitionTaskVo vo = submitRecognitionTask(dto);
    if (vo == null || StringUtils.isBlank(vo.getTaskId())) {
      return null;
    }
    RecognitionResultVo recognitionResultVo = recognitionResult(vo.getTaskId());
    return recognitionResultVo;
  }

  public RecognitionResultVo execRecognitionTask(String dto) {
    RecognitionTaskVo vo = submitRecognitionTask(dto);
    if (vo == null || StringUtils.isBlank(vo.getTaskId())) {
      return null;
    }
    RecognitionResultVo recognitionResultVo = recognitionResult(vo.getTaskId());
    return recognitionResultVo;
  }

  /**
   * 识别任务提交
   *
   * @param dto
   * @return
   */
  public RecognitionTaskVo submitRecognitionTask(RecognitionTaskDto dto) {
    String executeUrl = url(AI_RECOGNITION_TASK_API, AI_RECOGNITION_TASK_API_VERSION,
        JSONUtil.toJsonStr(dto));
    log.info("executeUrl:{},param:{}", executeUrl, JSONUtil.toJsonStr(dto));
    try {
      HttpResponse execute = HttpRequest.post(executeUrl)
          .body(JSONUtil.toJsonStr(dto))
          .execute();
      log.info("\r\n submitRecognitionTask->{}\r\n", execute.body());
      AiResult<RecognitionTaskVo> result = JSONUtil
          .toBean(execute.body(), new TypeReference<AiResult<RecognitionTaskVo>>() {
          }, false);
      return AiResultUtil.objResult(result, true);
    } catch (Exception e) {
      log.error("请求AI识别任务失败:{},{}", JSONUtil.toJsonStr(dto), e);
      return null;
    }
  }

  /**
   * 识别任务提交
   *
   * @param dto
   * @return
   */
  public RecognitionTaskVo submitRecognitionTask(String dto) {
    String executeUrl = url(AI_RECOGNITION_TASK_API, AI_RECOGNITION_TASK_API_VERSION,
        dto);
    log.info("submitRecognitionTask****executeUrl:{},param:{}", executeUrl, dto);
    try {
      HttpResponse execute = HttpRequest.post(executeUrl)
          .body(dto)
          .execute();
      log.info("\r\n submitRecognitionTask->{}\r\n", execute.body());
      AiResult<RecognitionTaskVo> result = JSONUtil
          .toBean(execute.body(), new TypeReference<AiResult<RecognitionTaskVo>>() {
          }, false);
      return AiResultUtil.objResult(result, true);
    } catch (Exception e) {
      return null;
    }
  }

  /**
   * 识别任务结果查询
   *
   * @param taskId
   * @return
   */
  public RecognitionResultVo recognitionResult(String taskId) {
    Map<String, String> param = MapUtil
        .builder(new HashMap<String, String>())
        .put("enterpriseId", enterpriseId)
        .put("taskId", taskId)
        .build();
    String executeUrl = url(AI_RECOGNITION_RESULT_API, AI_RECOGNITION_RESULT_API_VERSION,
        JSONUtil.toJsonStr(param));
    log.info("recognitionResult****executeUrl:{},param:{}", executeUrl, JSONUtil.toJsonStr(param));
    try {
      HttpResponse execute = HttpRequest.post(executeUrl)
          .body(JSONUtil.toJsonStr(param))
          .execute();
      log.info("\r\n recognitionResult->{}\r\n", execute.body());
      AiResult<RecognitionResultVo> result = JSONUtil
          .toBean(execute.body(), new TypeReference<AiResult<RecognitionResultVo>>() {
          }, false);
      return AiResultUtil.objResult(result, true);
    } catch (Exception e) {
      log.error("请求AI任务结果失败:{},{}", JSONUtil.toJsonStr(param), e);
      return null;
    }
  }

  /**
   * 查重任务提交
   *
   * @param dto
   * @return
   */
  public String submitRepeatTask(RepeatTaskDto dto) {
    dto.setEnterpeiseId(enterpriseId);
    String executeUrl = url(AI_REPEAT_TASK_API, AI_REPEAT_TASK_API_VERSION,
        JSONUtil.toJsonStr(dto));
    log.info("executeUrl:{},param:{}", executeUrl, JSONUtil.toJsonStr(dto));
    try {
      HttpResponse execute = HttpRequest.post(executeUrl)
          .body(JSONUtil.toJsonStr(dto))
          .execute();
      log.info("\r\n submitRepeatTask->{}\r\n", execute.body());
      AiResult<String> result = JSONUtil
          .toBean(execute.body(), new TypeReference<AiResult<String>>() {
          }, false);
      return AiResultUtil.objResult(result, true);
    } catch (Exception e) {
      log.error("请求AI识别任务失败:{},{}", JSONUtil.toJsonStr(dto), e);
      return null;
    }
  }

  /**
   * 查重任务结果查询
   *
   * @param taskId
   * @return
   */
  public RepeatResultVo repeatResult(String taskId) {
    Map<String, String> param = MapUtil
        .builder(new HashMap<String, String>())
        .put("enterpriseId", enterpriseId)
        .put("taskId", taskId)
        .build();
    String executeUrl = url(AI_REPEAT_RESULT_API, AI_REPEAT_RESULT_API_VERSION,
        JSONUtil.toJsonStr(param));
    try {
      HttpResponse execute = HttpRequest.post(executeUrl)
          .body(JSONUtil.toJsonStr(param))
          .execute();
      log.info("\r\n repeatResult->{}\r\n", execute.body());
      AiResult<RepeatResultVo> result = JSONUtil
          .toBean(execute.body(), new TypeReference<AiResult<RepeatResultVo>>() {
          }, false);
      return AiResultUtil.objResult(result, true);
    } catch (Exception e) {
      log.error("请求AI任务结果失败:{},{}", JSONUtil.toJsonStr(param), e);
      return null;
    }
  }

  public static void main(String[] args) {
    String appKey = "2e23f8520fa9";
    String appSecret = "78f7e7429e7b4aa8a0170671eeb39e95";
    String enterpriseId = "3506857863977547733";
    AiUtil ai = AiUtil.aiBuilder().setAppKey(appKey).setAppSecret(appSecret)
        .setEnterpriseId(enterpriseId).bulid();

//    LabelCreateVo test_2021 = ai.createLabel(Lists.newArrayList("TEST_2021"), enterpriseId);
//    System.out.println(test_2021);

    String msg = "{\n"
        + "  \"imgUrls\": [\n"
        + "    \"https://uma-shop-recognition-qa-1302115263.cos.ap-guangzhou.myqcloud.com/display/3506857863977547733/2021/9/26/1632636969238_951128.jpg\"\n"
        + "  ],\n"
        + "  \"callbackUrl\": \"https://ec5apitest.swellfun.com/rest/display/ai/v1/displayCallBack\",\n"
        + "  \"recognition\": {\n"
        + "    \"imgInfo\": {\n"
        + "      \"enterpriseId\": \"3506857863977547733\",\n"
        + "      \"latitude\": \"000\",\n"
        + "      \"longitude\": \"3.6\",\n"
        + "      \"storeId\": \"ZD00000152\",\n"
        + "      \"shotTime\": \"1623130416000\"\n"
        + "    },\n"
        + "    \"imgLibInfo\": {\n"
        + "      \"enable\": true,\n"
        + "      \"labels\": [\n"
        + "        \"ALL\"\n"
        + "      ]\n"
        + "    }\n"
        + "  }\n"
        + "}";

    String url = "\"https://ec5apitest.swellfun.com/rest/display/ai/v1/displayCallBack\"";
    String str = "\"https://uma-shop-recognition-qa-1302115263.cos.ap-guangzhou.myqcloud.com/display/3506857863977547733/2021/9/26/1632636969238_951128.jpg\"";
    String reqBodyStr = "{\"imgUrls\"" + ":" + "[" + str + "]," + "\"callbackUrl\":" + url + ","
        + "\"recognition\":" + "{" + "\"imgInfo\":" + "{" + "\"enterpriseId\":"
        + "\"3506857863977547733\"," + "\"latitude\":" + "\"000\"," + "\"longitude\":" + "\"3.6\","
        + "\"storeId\":" + "\"ZD00000152\"," + "\"shotTime\":" + "\"1623130416000\"" + "},"
        + "\"imgLibInfo\":" + "{" + "\"enable\":" + "true," + "\"labels\":" + "[" + "\"ALL\"" + "]"
        + "}" + "}" + "}";

    RecognitionTaskDto dto = getRecognitionTaskDto("ZD00000152", Lists.newArrayList(
        "https://bizcrm.oss-cn-beijing.aliyuncs.com/jpg/20210928/6df2ad7d0e334493b31fa1c6a3dc9c4f.jpg",
        "https://bizcrm.oss-cn-beijing.aliyuncs.com/jpg/20210928/dfcaf463e2684f1f9cc157007595deed.jpg"));

    String msg1 = "{\"imgUrls\":[\"https://bizcrm.oss-cn-beijing.aliyuncs.com/jpg/20210930/1a202c8f2ca7418e9ede43e1ad83b573.jpg\"],\"recognition\":{\"imgInfo\":{\"shotTime\":\"1632980217883\",\"storeId\":\"ZD00000152\",\"enterpriseId\":\"3506857863977547733\"},\"imgLibInfo\":{\"labels\":[\"ALL\"],\"enable\":true}},\"callbackUrl\":\"https://crmtest.biz-united.com.cn/sfa/ai/displayApiController/recognitionCallBack\"}";

//    System.out.println(reqBodyStr);
//    System.out.println(JSONUtil.toJsonStr(dto));

//    RecognitionResultVo recognitionResultVo = ai.execRecognitionTask(getRecognitionTaskDto("123",
//        Lists.newArrayList(
//            "https://bizcrm.oss-cn-beijing.aliyuncs.com/jpg/20210928/6df2ad7d0e334493b31fa1c6a3dc9c4f.jpg",
//            "https://bizcrm.oss-cn-beijing.aliyuncs.com/jpg/20210928/dfcaf463e2684f1f9cc157007595deed.jpg")));

    RecognitionResultVo recognitionResultVo = ai.recognitionResult("861e89a121b811ec88549ac9502ce7fc");
    System.out.println(JSONUtil.toJsonPrettyStr(recognitionResultVo));
  }


  private static RecognitionTaskDto getRecognitionTaskDto(String clientCode,
      List<String> imgList) {
    String callbackUrl = "https://ec5apitest.swellfun.com/rest/display/ai/v1/displayCallBack";
    RecognitionTaskDto dto = new RecognitionTaskDto();
    dto.setCallbackUrl(callbackUrl);
    dto.setImgUrls(imgList);
    Recognition recognition = new Recognition();
    ImgInfo imgInfo = new ImgInfo();
    imgInfo.setEnterpriseId("3506857863977547733");
    imgInfo.setStoreId(clientCode);
    imgInfo.setLatitude("23.3");
    imgInfo.setLongitude("23.3");
    imgInfo.setShotTime("1623130416000");
    recognition.setImgInfo(imgInfo);
    ImgLibInfo imgLibInfo = new ImgLibInfo();
    imgLibInfo.setEnable(true);
    imgLibInfo.setLabels(Lists.newArrayList("ALL"));
    recognition.setImgLibInfo(imgLibInfo);
    dto.setRecognition(recognition);
    return dto;
  }
}
