package com.biz.crm.asexecution.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.asexecution.service.ISfaAsCashingService;
import com.biz.crm.asexecution.service.ISfaAsExecutionService;
import com.biz.crm.asexecution.service.ISfaAsTreatyService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemePosApplyRespVo;
import com.biz.crm.nebular.sfa.asexecution.req.*;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsCashingRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsExecutionDetailRespVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsTreatyRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 方案活动执行;
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Slf4j
@RestController
@RequestMapping("/sfaAsExecutionController")
@Api(tags = "方案活动执行;")
public class SfaAsExecutionController {

    @Autowired
    private ISfaAsExecutionService sfaAsExecutionService;

    @Autowired
    private ISfaAsTreatyService sfaAsTreatyService;

    @Autowired
    private ISfaAsCashingService sfaAsCashingService;


    /**
     * 活动协议保存
     */
    @ApiOperation(value = "活动协议保存")
    @PostMapping("/saveSfaAsTreaty")
    @CrmLog
    public Result saveSfaAsTreaty(@RequestBody SfaAsTreatyReqVo sfaAsTreatyReqVo) {
        sfaAsExecutionService.saveSfaAsTreaty(sfaAsTreatyReqVo);
        return Result.ok();
    }

    /**
     * 活动协议报表
     */
    @ApiOperation(value = "活动协议报表")
    @PostMapping("/treatyReport")
    @CrmLog
    public Result<PageResult<SfaAsTreatyRespVo>> list(@RequestBody SfaAsTreatyReqVo params) {
        PageResult<SfaAsTreatyRespVo> result = sfaAsTreatyService.report(params);
        return Result.ok(result);
    }

    /**
     * 活动对付报表
     */
    @ApiOperation(value = "活动对付报表")
    @PostMapping("/cashReport")
    @CrmLog
    public Result<PageResult<SfaAsCashingRespVo>> list(@RequestBody SfaAsCashingReqVo params) {
        PageResult<SfaAsCashingRespVo> result = sfaAsCashingService.report(params);
        return Result.ok(result);
    }

    /**
     * 根据兑付ID查询兑付详情
     */
    @ApiOperation(value = "根据兑付ID查询兑付详情")
    @GetMapping("/findByCashId/{cashId}")
    @CrmLog
    public Result<SfaAsCashingRespVo> findByCashId(@PathVariable("cashId") String cashId) {
        SfaAsCashingRespVo result = sfaAsCashingService.findById(cashId);
        return Result.ok(result);
    }

    /**
     * 活动执行保存
     */
    @ApiOperation(value = "活动执行保存")
    @PostMapping("/saveSfaAsExecution")
    @CrmLog
    public Result saveSfaAsExecution(@RequestBody SfaAsExecutionReqVo sfaAsTreatyReqVo) {
        sfaAsExecutionService.saveSfaAsExecution(sfaAsTreatyReqVo);
        return Result.ok();
    }

    /**
     * 活动兑付保存
     */
    @ApiOperation(value = "活动兑付保存")
    @PostMapping("/saveSfaAsCashing")
    @CrmLog
    public Result saveSfaAsCashing(@RequestBody SfaAsCashingReqVo sfaAsTreatyReqVo) {
        sfaAsExecutionService.saveSfaAsCashing(sfaAsTreatyReqVo);
        return Result.ok();
    }


    /**
     * 活动终止保存
     */
    @ApiOperation(value = "活动终止保存")
    @PostMapping("/saveAsStop")
    @CrmLog
    public Result saveAsStop(@RequestBody SfaAsStopReqVo sfaAsTreatyReqVo) {
        sfaAsTreatyReqVo.setStopState(YesNoEnum.yesNoEnum.ONE.getValue());
        sfaAsExecutionService.saveAsStop(sfaAsTreatyReqVo);
        return Result.ok();
    }

    /**
     * 通过活动编码和终端编码查询执行详情
     */
    @ApiOperation(value = "通过活动编码和终端编码查询执行详情")
    @PostMapping("/queryExecutionDetailByActivityCodeAndTerminalCode")
    @CrmLog
    public Result<SfaAsExecutionDetailRespVo> queryExecutionDetailByActivityCodeAndTerminalCode(@RequestBody SfaAsExecutionDetailReqVo reqVo) {
        SfaAsExecutionDetailRespVo respVo = sfaAsExecutionService.queryExecutionDetailByActivityCodeAndTerminalCode(reqVo);
        return Result.ok(respVo);
    }

    /**
     * 通过门店编码和拜访ID查询方案活动
     */
    @ApiOperation(value = "通过门店编码和拜访ID查询方案活动")
    @PostMapping("/findActSchemePosApplyByVisitPlanInfoId")
    @CrmLog
    public Result<List<SfaActSchemePosApplyRespVo>> findActSchemeByVisitPlanInfoId(@RequestBody SfaAsExecutionDetailReqVo reqVo) {
        List<SfaActSchemePosApplyRespVo> respVo = sfaAsExecutionService.findActSchemeByVisitPlanInfoId(reqVo);
        return Result.ok(respVo);
    }
}
