package com.biz.crm.asexecution.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigDecimal;

/**
 * 方案活动兑付;实体类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_as_cashing")
@CrmTable(name = "sfa_as_cashing", tableNote = "方案活动兑付",indexes = {
        @Index(name ="sfa_as_cashing_index1",columnList = "activity_code"),
        @Index(name ="sfa_as_cashing_index2",columnList = "terminal_code")
})
public class SfaAsCashingEntity extends CrmExtTenEntity<SfaAsCashingEntity> {

    private static final long serialVersionUID = -56778409888085394L;
    /**
     * 活动编码
     */
    @CrmColumn(name = "activity_code", length = 32, note = "活动编码")
    private String activityCode;

    /**
     * 终端编码
     */
    @CrmColumn(name = "terminal_code", length = 32, note = "终端编码")
    private String terminalCode;

    /**
     * 终端名称
     */
    @CrmColumn(name = "terminal_name", length = 100, note = "终端名称")
    private String terminalName;

    /**
     * 终端地址
     */
    @CrmColumn(name = "terminal_addr", length = 512, note = "终端地址")
    private String terminalAddr;

    /**
     * 终端联系人
     */
    @CrmColumn(name = "terminal_user", length = 100, note = "终端联系人")
    private String terminalUser;

    /**
     * 终端电话
     */
    @CrmColumn(name = "terminal_phone", length = 100, note = "终端电话")
    private String terminalPhone;

    /**
     * 转账金额
     */
    @CrmColumn(name = "transfer_amount", mysqlType = "decimal(12,2)", oracleType = "NUMBER(12,2)", note = "转账金额")
    private BigDecimal transferAmount;


}
