package com.biz.crm.asexecution.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigDecimal;
import java.math.BigInteger;

/**
 * 方案活动执行产品数据采集;实体类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_as_execution_product")
@CrmTable(name = "sfa_as_execution_product", tableNote = "方案活动执行产品数据采集",indexes = {
        @Index(name = "sfa_execution_product_index1",columnList = "execution_id"),
        @Index(name = "sfa_execution_product_index2",columnList = "setmeal_id")
})
public class SfaAsExecutionProductEntity extends CrmExtTenEntity<SfaAsExecutionProductEntity> {

    /**
     * 执行id
     */
    @CrmColumn(name = "execution_id", length = 32, note = "执行id")
    private String executionId;
    /**
     *  方案套餐id
     */
    @CrmColumn(name = "setmeal_id", length = 32, note = "方案套餐id")
    private String setmealId;
    /**
     * 产品编码
     */
    @CrmColumn(name = "product_code", length = 32, note = "产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @CrmColumn(name = "product_name", length = 100, note = "产品名称")
    private String productName;

    /**
     * 行类型(1-本品,2-赠品)
     */
    @CrmColumn(name = "itme_type", length = 10, note = "行类型(1-本品,2-赠品)")
    private String itmeType;

    /**
     * 数量
     */
    @CrmColumn(name = "product_num", mysqlType = "decimal(12,0)", oracleType = "NUMBER(12,0)", note = "数量")
    private BigInteger productNum;

    /**
     * 价格
     */
    @CrmColumn(name = "price", mysqlType = "decimal(12,2)", oracleType = "NUMBER(12,2)", note = "价格")
    private BigDecimal price;


}
