package com.biz.crm.asexecution.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 方案活动终止;实体类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_as_stop")
@CrmTable(name = "sfa_as_stop", tableNote = "方案活动终止",indexes = {
        @Index(name ="sfa_as_stop_index1",columnList ="activity_code" ),
        @Index(name ="sfa_as_stop_index2",columnList ="terminal_code" ),
        @Index(name ="sfa_as_stop_index3",columnList ="pos_code" ),
        @Index(name ="sfa_as_stop_index4",columnList ="org_code" )
})
public class SfaAsStopEntity extends CrmExtTenEntity<SfaAsStopEntity> {

    /**
     * 活动编码
     */
    @CrmColumn(name = "activity_code", length = 32, note = "活动编码")
    private String activityCode;

    /**
     * 终端编码
     */
    @CrmColumn(name = "terminal_code", length = 32, note = "终端编码")
    private String terminalCode;
    /**
     * 终端名称
     */
    @CrmColumn(name = "terminal_name", length = 100, note = "终端名称")
    private String terminalName;

    /**
     * 终结状态(0:未终止;1:终止)
     */
    @CrmColumn(name = "stop_state", length = 10, note = "终结状态(0:未终止;1:终止)")
    private String stopState;
    /**
     * 终止时间
     */
    @CrmColumn(name = "stop_date", length = 50, note = "终止时间")
    private String stopDate;

    /**
     * 人员账号
     */
    @CrmColumn(name = "user_name", length = 50, note = "人员账号")
    private String userName;
    /**
     * 人员姓名
     */
    @CrmColumn(name = "real_name", length = 100, note = "人员姓名")
    private String realName;
    /**
     * 职位名称
     */
    @CrmColumn(name = "pos_name", length = 100, note = "职位名称")
    private String posName;
    /**
     * 职位编码
     */
    @CrmColumn(name = "pos_code", length = 50, note = "职位编码")
    private String posCode;
    /**
     * 组织名称
     */
    @CrmColumn(name = "org_name", length = 100, note = "组织名称")
    private String orgName;
    /**
     * 组织编码
     */
    @CrmColumn(name = "org_code", length = 50, note = "组织编码")
    private String orgCode;


}
