package com.biz.crm.asexecution.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import javax.persistence.Index;
import java.math.BigInteger;

/**
 * 方案活动协议-货物兑换产品;实体类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_as_treaty_convert_product")
@CrmTable(name = "sfa_as_treaty_convert_product", tableNote = "方案活动协议-货物兑换产品",indexes = {
        @Index(name = "treaty_convert_product_index1",columnList = "treaty_id"),
        @Index(name = "treaty_convert_product_index2",columnList = "product_code")
})
public class SfaAsTreatyConvertProductEntity extends CrmExtTenEntity<SfaAsTreatyConvertProductEntity> {

    /**
     * 协议id
     */
    @CrmColumn(name = "treaty_id", length = 32, note = "协议id")
    private String treatyId;
    /**
     * 产品编码
     */
    @CrmColumn(name = "product_code", length = 32, note = "产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @CrmColumn(name = "product_name", length = 100, note = "产品名称")
    private String productName;
    /**
     * 数量
     */
    @CrmColumn(name = "product_num", mysqlType = "decimal(12,0)", oracleType = "NUMBER(12,0)", note = "数量")
    private BigInteger productNum;

    /**
     * 商品价格
     */
    @CrmColumn(name = "price",mysqlType = "decimal(12,2)",oracleType = "NUMBER(12,2)",note = "价格")
    private BigDecimal price;

    /**
     * 行类型(1:支付货品;2:奖励货品)
     */
    @CrmColumn(name = "item_type", length = 32, note = "行类型(1:支付货品;2:奖励货品)")
    private String itemType;


}
