package com.biz.crm.asexecution.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 方案活动协议-陈列产品;实体类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_as_treaty_display_product")
@CrmTable(name = "sfa_as_treaty_display_product", tableNote = "方案活动协议-陈列产品",indexes = {
        @Index(name ="treaty_display_product_index1",columnList ="treaty_id" ),
        @Index(name ="treaty_display_product_index2",columnList ="product_code" )
})
public class SfaAsTreatyDisplayProductEntity extends CrmExtTenEntity<SfaAsTreatyDisplayProductEntity> {

    /**
     * 协议id
     */
    @CrmColumn(name = "treaty_id", length = 32, note = "协议id")
    private String treatyId;
    /**
     * 产品编码
     */
    @CrmColumn(name = "product_code", length = 32, note = "产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @CrmColumn(name = "product_name", length = 100, note = "产品名称")
    private String productName;

}
