package com.biz.crm.asexecution.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.biz.crm.tpmact.model.SfaTpmActBaseEntity;
import com.biz.crm.util.CrmBeanUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigDecimal;

/**
 * 方案活动协议;实体类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_as_treaty")
@CrmTable(name = "sfa_as_treaty", tableNote = "方案活动协议", indexes = {
        @Index(name = "sfa_as_treaty_index1", columnList = "treaty_code"),
        @Index(name = "sfa_as_treaty_index2", columnList = "dealer_code"),
        @Index(name = "sfa_as_treaty_index3", columnList = "activity_code"),

})
public class SfaAsTreatyEntity extends SfaTpmActBaseEntity<SfaAsTreatyEntity> {

    /**
     * '协议编码'
     */
    @CrmColumn(name = "treaty_code", length = 32, note = "协议编码")
    private String treatyCode;

    /**
     * '协议状态'
     */
    @CrmColumn(name = "treaty_status", length = 32, note = "协议状态")
    private String treatyStatus;

    /**
     * 经销商编码
     */
    @CrmColumn(name = "dealer_code", length = 32, note = "经销商编码")
    private String dealerCode;

    /**
     * 经销商名称
     */
    @CrmColumn(name = "dealer_name", length = 256, note = "经销商名称")
    private String dealerName;

    /**
     * '图片对象名称'
     */
    @CrmColumn(name = "object_name", length = 512, note = "图片对象名称")
    private String objectName;

    /**
     * '图片相对路径'
     */
    @CrmColumn(name = "url_path", length = 512, note = "图片相对路径")
    private String urlPath;

    /**
     * '图片路径地址'
     */
    @CrmColumn(name = "url_path_prefix", length = 512, note = "图片路径地址")
    private String urlPathPrefix;

    /**
     * 活动编码
     */
    @CrmColumn(name = "activity_code", length = 32, note = "活动编码")
    private String activityCode;
    /**
     * 终端编码
     */
    @CrmColumn(name = "terminal_code", length = 32, note = "终端编码")
    private String terminalCode;
    /**
     * 终端名称
     */
    @CrmColumn(name = "terminal_name", length = 32, note = "终端名称")
    private String terminalName;
    /**
     * 陈列品牌
     */
    @CrmColumn(name = "display_brand", length = 32, note = "陈列品牌")
    private String displayBrand;
    /**
     * 陈列品项
     */
    @CrmColumn(name = "display_item", length = 32, note = "陈列品项")
    private String displayItem;
    /**
     * 陈列位置
     */
    @CrmColumn(name = "display_place", length = 32, note = "陈列位置")
    private String displayPlace;
    /**
     * 陈列规格
     */
    @CrmColumn(name = "display_specs", length = 32, note = "陈列规格")
    private String displaySpecs;
    /**
     * 陈列件数
     */
    @CrmColumn(name = "display_number", length = 32, note = "陈列件数")
    private String displayNumber;
    /**
     * 陈列开始时间
     */
    @CrmColumn(name = "display_start_time", length = 32, note = "陈列开始时间")
    private String displayStartTime;
    /**
     * 陈列结束时间
     */
    @CrmColumn(name = "display_end_time", length = 32, note = "陈列结束时间")
    private String displayEndTime;
    /**
     * 陈列月份
     */
    @CrmColumn(name = "display_month", length = 32, note = "陈列月份")
    private String displayMonth;

    /**
     * 每月支付现金
     */
    @CrmColumn(name = "month_pay_amount", mysqlType = "decimal(10,2)", oracleType = "NUMBER(10,2)", note = "每月支付现金")
    private BigDecimal monthPayAmount;
    /**
     * 合计奖励现金
     */
    @CrmColumn(name = "total_amount", mysqlType = "decimal(10,2)", oracleType = "NUMBER(10,2)", note = "合计奖励现金")
    private BigDecimal totalAmount;
    /**
     * 奖励收款人
     */
    @CrmColumn(name = "payee", length = 60, note = "奖励收款人")
    private String payee;
    /**
     * 联系电话
     */
    @CrmColumn(name = "contact_phone", length = 32, note = "联系电话")
    private String contactPhone;

    /**
     * 总价
     */
    @CrmColumn(name = "total_price", mysqlType = "decimal(12,2)", oracleType = "NUMBER(12,2)", note = "总价")
    private BigDecimal totalPrice;

    @CrmColumn(name = "treaty_source", length = 32, note = "协议来源,数据字典(agreement_source)")
    private String treatySource;

    public void setTerminalCode(String terminalCode) {
        this.terminalCode = terminalCode;
        super.setClientCode(terminalCode);
    }

    public void setTerminalName(String terminalName) {
        this.terminalName = terminalName;
        super.setClientName(terminalName);
    }

}
