package com.biz.crm.asexecution.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.asexecution.model.SfaAsExecutionEntity;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemePosApplyRespVo;
import com.biz.crm.nebular.sfa.asexecution.req.*;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsExecutionDetailRespVo;

import java.util.List;

/**
 * 方案活动执行;接口
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
public interface ISfaAsExecutionService extends IService<SfaAsExecutionEntity> {

    /**
     * 活动协议保存
     *
     * @param sfaAsTreatyReqVo
     */
    void saveSfaAsTreaty(SfaAsTreatyReqVo sfaAsTreatyReqVo);

    /**
     * 活动在执行
     *
     * @param sfaAsTreatyReqVo
     */
    void saveSfaAsExecution(SfaAsExecutionReqVo sfaAsTreatyReqVo);

    /**
     * 活动兑付
     *
     * @param sfaAsTreatyReqVo
     */
    void saveSfaAsCashing(SfaAsCashingReqVo sfaAsTreatyReqVo);

    /**
     * 活动终止保存
     *
     * @param sfaAsTreatyReqVo
     */
    void saveAsStop(SfaAsStopReqVo sfaAsTreatyReqVo);


    /**
     * 通过活动编码和终端编码查询执行详情
     *
     * @param reqVo
     * @return
     */
    SfaAsExecutionDetailRespVo queryExecutionDetailByActivityCodeAndTerminalCode(SfaAsExecutionDetailReqVo reqVo);

    /**
     * 订单修改商品同步修改活动执行商品信息
     *
     * @param params
     */
    void updateExecutionProduct(SfaAsExecuteOrderProductReqVo params);

    /**
     * 通过门店编码和拜访ID查询方案活动
     *
     * @param reqVo
     * @return
     */
    List<SfaActSchemePosApplyRespVo> findActSchemeByVisitPlanInfoId(SfaAsExecutionDetailReqVo reqVo);
}

