package com.biz.crm.asexecution.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.asexecution.model.SfaAsTreatyEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsTreatyReqVo;
import com.biz.crm.nebular.sfa.asexecution.resp.SfaAsTreatyRespVo;
import com.biz.crm.nebular.sfa.tpmact.VisitBaseVo;
import com.biz.crm.nebular.sfa.tpmact.displaytreaty.CashTreatyVo;
import com.biz.crm.nebular.sfa.tpmact.displaytreaty.GoodsTreatyVo;
import com.biz.crm.nebular.sfa.tpmact.displaytreaty.SfaTpmActTreatyRedisVo;

/**
 * 方案活动协议;接口
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
public interface ISfaAsTreatyService extends IService<SfaAsTreatyEntity> {

    /**
     * 活动协议报表
     * @param params
     * @return
     */
    PageResult<SfaAsTreatyRespVo> report(SfaAsTreatyReqVo params);

    /**
     * 工作台-货品协议保存
     * @param vo
     */
    String saveWorkBenchGoodsTreaty(GoodsTreatyVo vo);

    /**
     * 工作台-现金协议保存
     * @param vo
     */
    String saveWorkBenchCashTreaty(CashTreatyVo vo);

    /**
     * 拜访执行-tpm活动-陈列协议-货品协议保存
     * @param vo
     */
    String saveVisitStepGoodsTreaty(VisitBaseVo<GoodsTreatyVo> vo);


    /**
     * 拜访执行-tpm活动-陈列协议-现金协议保存
     * @param vo
     */
    String saveVisitStepCashTreaty(VisitBaseVo<CashTreatyVo> vo);

    /**
     * 获取tpm活动-陈列协议
     * @param id
     * @return
     */
    String loadTpmActTreatyDetail(String id);
}

