package com.biz.crm.assistant.controller;

import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.visitinfo.service.impl.SfaVisitPlanInfoRedisDataServiceEsImpl;
import com.biz.crm.visitstep.req.GetVisitStepAbnormalReq;
import com.biz.crm.visitstep.resp.SfaVisitStepAbnormalTableRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.assistant.service.ISfaVisitStepAbnormalService;
import com.biz.crm.nebular.sfa.assistant.resp.SfaVisitStepAbnormalRespVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaVisitStepAbnormalReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 拜访（异常提报） 
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Slf4j
@RestController
@RequestMapping("/sfavisitstepabnormal")
@Api(tags = "拜访（异常提报） ")
public class SfaVisitStepAbnormalController {
    @Autowired
    private ISfaVisitStepAbnormalService sfaVisitStepAbnormalService;
    @Resource
    private SfaVisitPlanInfoRedisDataServiceEsImpl sfaVisitPlanInfoRedisDataServiceEs;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaVisitStepAbnormalRespVo>> list(@RequestBody SfaVisitStepAbnormalReqVo sfaVisitStepAbnormalReqVo) {
        PageResult<SfaVisitStepAbnormalRespVo> result=sfaVisitStepAbnormalService.findList(sfaVisitStepAbnormalReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaVisitStepAbnormalRespVo> query(@RequestBody SfaVisitStepAbnormalReqVo sfaVisitStepAbnormalReqVo) {
        SfaVisitStepAbnormalRespVo respVo=sfaVisitStepAbnormalService.query(sfaVisitStepAbnormalReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaVisitStepAbnormalReqVo sfaVisitStepAbnormalReqVo) {
        sfaVisitStepAbnormalService.save(sfaVisitStepAbnormalReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaVisitStepAbnormalReqVo sfaVisitStepAbnormalReqVo) {
        sfaVisitStepAbnormalService.update(sfaVisitStepAbnormalReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaVisitStepAbnormalReqVo sfaVisitStepAbnormalReqVo) {
        sfaVisitStepAbnormalService.deleteBatch(sfaVisitStepAbnormalReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaVisitStepAbnormalReqVo sfaVisitStepAbnormalReqVo) {
        sfaVisitStepAbnormalService.enableBatch(sfaVisitStepAbnormalReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaVisitStepAbnormalReqVo sfaVisitStepAbnormalReqVo) {
        sfaVisitStepAbnormalService.disableBatch(sfaVisitStepAbnormalReqVo);
        return Result.ok("禁用成功");
    }

    /**
     * 报表
     */
    @ApiOperation(value = "异常提报报表")
    @PostMapping("/findAbnormalTable")
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<SfaVisitStepAbnormalTableRespVo>> findAbnormalTable(@RequestBody GetVisitStepAbnormalReq req) {
        PageResult<SfaVisitStepAbnormalTableRespVo> result=sfaVisitPlanInfoRedisDataServiceEs.getVisitExecuteInfoReportPage(req);
        return Result.ok(result);
    }
}
