package com.biz.crm.assistant.controller;

import com.biz.crm.aop.CrmAPIDiscard;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.assistant.service.ISfaWorkTaskNoticeService;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskNoticeRespVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskNoticeReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 工作任务(抄送) 
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Slf4j
@RestController
@RequestMapping("/sfaworktasknotice")
@Api(tags = "工作任务(抄送) ")
public class SfaWorkTaskNoticeController {
    @Autowired
    private ISfaWorkTaskNoticeService sfaWorkTaskNoticeService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    @CrmAPIDiscard
    public Result<PageResult<SfaWorkTaskNoticeRespVo>> list(@RequestBody SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo) {
        PageResult<SfaWorkTaskNoticeRespVo> result=sfaWorkTaskNoticeService.findList(sfaWorkTaskNoticeReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    @CrmAPIDiscard
    public Result<SfaWorkTaskNoticeRespVo> query(@RequestBody SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo) {
        SfaWorkTaskNoticeRespVo respVo=sfaWorkTaskNoticeService.query(sfaWorkTaskNoticeReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    @CrmAPIDiscard
    public Result save(@RequestBody SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo) {
        sfaWorkTaskNoticeService.save(sfaWorkTaskNoticeReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    @CrmAPIDiscard
    public Result update(@RequestBody SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo) {
        sfaWorkTaskNoticeService.update(sfaWorkTaskNoticeReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    @CrmAPIDiscard
    public Result delete(@RequestBody SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo) {
        sfaWorkTaskNoticeService.deleteBatch(sfaWorkTaskNoticeReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    @CrmAPIDiscard
    public Result enable(@RequestBody SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo) {
        sfaWorkTaskNoticeService.enableBatch(sfaWorkTaskNoticeReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    @CrmAPIDiscard
    public Result disable(@RequestBody  SfaWorkTaskNoticeReqVo sfaWorkTaskNoticeReqVo) {
        sfaWorkTaskNoticeService.disableBatch(sfaWorkTaskNoticeReqVo);
        return Result.ok("禁用成功");
    }
}
