package com.biz.crm.assistant.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.assistant.service.ISfaWorkTaskObjectService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskObjectReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskObjectRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 工作任务-执行对象
 *
 * @author yangshan
 * @date 2021/3/6 16:33
 */
@Slf4j
@RestController
@RequestMapping("/sfaWorkTaskObjectController")
@Api(tags = "工作任务-执行对象")
public class SfaWorkTaskObjectController {

    @Autowired
    private ISfaWorkTaskObjectService sfaWorkTaskObjectService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaWorkTaskObjectRespVo>> findList(@RequestBody SfaWorkTaskObjectReqVo reqVo){
        PageResult<SfaWorkTaskObjectRespVo> result = sfaWorkTaskObjectService.findList(reqVo);
        return Result.ok(result);
    }

    /**
     * 批量保存
     *
     * @param reqVos
     * @return
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody List<SfaWorkTaskObjectReqVo> reqVos){
        sfaWorkTaskObjectService.save(reqVos);
        return Result.ok();
    }

    /**
     * 根据任务id批量删除
     *
     * @param taskIds
     * @return
     */
    @ApiOperation(value = "根据任务id批量删除")
    @PostMapping("/deleteByTaskIds")
    @CrmLog
    public Result deleteByTaskIds(@RequestBody List<String> taskIds){
        sfaWorkTaskObjectService.delete(taskIds);
        return Result.ok();
    }
}
