package com.biz.crm.assistant.mapper;

import com.biz.crm.assistant.model.SfaWorkSummaryEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryReportFromReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryStaffReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkSummaryReportFromsRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkSummaryStaffRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReceveRespVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkSummaryRespVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryReqVo;
import java.util.List;
import java.util.Map;

/**
 * 工作总结 
 * 
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
public interface SfaWorkSummaryMapper extends BaseMapper<SfaWorkSummaryEntity> {
    /**
     * 列表
     * @param
     * @param sfaWorkSummaryReqVo
     * @return
     */
    List<SfaWorkSummaryRespVo> findList( @Param("vo") SfaWorkSummaryReqVo sfaWorkSummaryReqVo);

    /**
     * 根据任务总结id查询单条
     * @param summaryId
     * @return
     */
    SfaWorkSummaryRespVo findOneById(@Param("summaryId") String summaryId);

    /**
     * 查询指定人员是否有已存在工作总结
     * @param reqVo
     * @return
     */
    SfaWorkSummaryRespVo findOneByMe(@Param("vo") SfaWorkSummaryReqVo reqVo);

    /**
     * 查询指定人员的信息
     * @param sfaWorkSummaryStaffReqVo
     * @param startDate
     * @param endDate
     * @param summaryType
     * @return
     */
    SfaWorkSummaryRespVo findOneByLists(@Param("vo") SfaWorkSummaryStaffReqVo sfaWorkSummaryStaffReqVo, @Param("startDate") String startDate, @Param("overDate") String endDate, @Param("summaryType") String summaryType);

    /**
     * 查询工作报表
     * @param reqVo
     * @return
     */
    @SqlPrivilege(orgCode = "sfa_work_summary.create_org_code",posCode = "sfa_work_summary.create_pos_code")
    List<SfaWorkSummaryReportFromsRespVo> findListByReportForms(Page<SfaWorkTaskReceveRespVo> page, @Param("vo") SfaWorkSummaryReportFromReqVo reqVo);

    /**
     * 根据入参集合获取状态
     * @param respVos
     * @param startDate
     * @param endDate
     * @param summaryType
     * @return
     */
    List<SfaWorkSummaryStaffRespVo> queryReportStatus(@Param("vo") List<MdmPositionPageRespVo> respVos,
                                                      @Param("startDate") String startDate, @Param("overDate") String endDate,
                                                      @Param("summaryType") String summaryType);



    Integer getSfaWorkSummaryByCount(@Param("vo") SfaWorkSummaryReqVo sfaWorkSummaryReqVo);

    /**
     * 获取某月完成日报
     * @param sfaWorkSummaryReqVo
     * @return
     */
    Integer getSfaWorkSummaryPrimaryByCount(@Param("vo") SfaWorkSummaryReqVo sfaWorkSummaryReqVo);

}
