package com.biz.crm.assistant.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.assistant.model.SfaWorkTaskReceveEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.nebular.sfa.assistant.resp.SfaTaskTimeExpiredRespVo;
import org.apache.ibatis.annotations.Param;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReceveRespVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReceveReqVo;
import java.util.List;
import java.util.Map;

/**
 * 工作任务(接收) 
 * 
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
public interface SfaWorkTaskReceveMapper extends BaseMapper<SfaWorkTaskReceveEntity> {
    /**
     * 列表
     * @param sfaWorkTaskReceveReqVo
     * @return
     */
    List<SfaWorkTaskReceveRespVo> findList(Page<SfaWorkTaskReceveRespVo> page, @Param("vo") SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo);

    /**
     * 非待定列表
     * @param sfaWorkTaskReceveReqVo
     * @return
     */
    List<SfaWorkTaskReceveRespVo> findOffTheStocks(Page<SfaWorkTaskReceveRespVo> page,@Param("vo") SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo);

    /**
     * 根据入参查询当天的完成比例
     * @param queryDate
     * @param receverCode
     * @return
     */
    List<String> findStatusByQueryDate(@Param("postCode") String postCode, @Param("orgCode") String orgCode, @Param("queryDate") String queryDate, @Param("receverCode") String receverCode);


    /**
     * 更新单一任务
     * @param sfaWorkTaskReceveReqVo
     * @return
     */
    int updateOne(@Param("vo")SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo );

    /**
     * 根据taskid查询
     * @param taskId
     * @return
     */
    List<SfaWorkTaskReceveRespVo> findListByTaskId(@Param("taskId") String taskId);

    /**
     * 根据id集合
     * @param map
     * @return
     */
    List<SfaWorkTaskReceveRespVo> findOneByTaskId(@Param("map") Map map);

    /**
     * 定时过期任务列表
     * @param thisTime
     * @return
     */
    List<SfaTaskTimeExpiredRespVo> findTimeExpiredByTime(@Param("thisTime") String thisTime, @Param("executeStatus") String executeStatus);

    /**
     * 根据id查询
     * @param receveId
     * @return
     */
    SfaWorkTaskReceveRespVo findOneByReceveId(@Param("receveId") String receveId);

}
