package com.biz.crm.assistant.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.assistant.model.SfaWorkTaskReleaseEntity;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReleaseReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReportReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReleaseRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReportRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 工作任务(发布) 
 * 
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
public interface SfaWorkTaskReleaseMapper extends BaseMapper<SfaWorkTaskReleaseEntity> {
    /**
     * 列表
     * @param page
     * @param sfaWorkTaskReleaseReqVo
     * @return
     */
    List<SfaWorkTaskReleaseRespVo> findList(Page<SfaWorkTaskReleaseRespVo> page, @Param("vo") SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo);

    /**
     * 列表
     * @param sfaWorkTaskReleaseReqVo
     * @return
     */
    List<SfaWorkTaskReleaseRespVo> findListAll(Page<SfaWorkTaskReleaseRespVo> page,  @Param("vo") SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo);


    /**
     * 查询单一任务
     * @param taskId
     * @return
     */
    SfaWorkTaskReleaseRespVo findOne(@Param("taskId") String taskId);

    /**
     * 查询工作任务报表
     * @param page
     * @param sfaWorkTaskReportReqVo
     * @return
     */
    @SqlPrivilege(orgCode = "tr.recever_org_code",posCode = "tr.recever_pos_code")
    List<SfaWorkTaskReportRespVo> findSfaWorkTaskReportList(Page<SfaWorkTaskReportRespVo> page, @Param("vo") SfaWorkTaskReportReqVo sfaWorkTaskReportReqVo);

}
